/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder.support;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.SuperStructure;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.impl.AbstractMessageRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnlyAllowableSegmentsInSuperstructureRule
extends AbstractMessageRule {
    public static final MessageRule ONLY_ALLOWABLE_SEGMENTS = new OnlyAllowableSegmentsInSuperstructureRule();

    @Override
    public ValidationException[] apply(Message msg) {
        ArrayList<ValidationException> exceptions = new ArrayList<ValidationException>();
        if (msg instanceof SuperStructure) {
            this.checkStructure((SuperStructure)((Object)msg), exceptions);
        }
        return exceptions.toArray(new ValidationException[exceptions.size()]);
    }

    private void checkStructure(SuperStructure theMsg, List<ValidationException> theExceptions) {
        String messageStructure = theMsg.getMessage().getName();
        block2: for (String name : theMsg.getNames()) {
            try {
                for (Structure rep : theMsg.getAll(name)) {
                    if (rep.isEmpty()) continue;
                    Set<String> structuresWhichChildAppliesTo = theMsg.getStructuresWhichChildAppliesTo(name);
                    if (structuresWhichChildAppliesTo.contains(messageStructure)) continue block2;
                    String msgSimpleName = theMsg.getMessage().getClass().getSimpleName();
                    theExceptions.add(new ValidationException("Message (superstructure " + msgSimpleName + ") of type " + messageStructure + " must not have content in " + name));
                    continue block2;
                }
            }
            catch (HL7Exception e) {
                throw new Error("Can't get rep of structure " + name + ". This is probably a HAPI bug");
            }
        }
    }
}

