/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.restore;

import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeOperationRequestBuilder;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.common.settings.Settings;

public class RestoreSnapshotRequestBuilder
extends MasterNodeOperationRequestBuilder<RestoreSnapshotRequest, RestoreSnapshotResponse, RestoreSnapshotRequestBuilder, ClusterAdminClient> {
    public RestoreSnapshotRequestBuilder(ClusterAdminClient clusterAdminClient) {
        super(clusterAdminClient, new RestoreSnapshotRequest());
    }

    public RestoreSnapshotRequestBuilder(ClusterAdminClient clusterAdminClient, String repository, String name) {
        super(clusterAdminClient, new RestoreSnapshotRequest(repository, name));
    }

    public RestoreSnapshotRequestBuilder setSnapshot(String snapshot) {
        ((RestoreSnapshotRequest)this.request).snapshot(snapshot);
        return this;
    }

    public RestoreSnapshotRequestBuilder setRepository(String repository) {
        ((RestoreSnapshotRequest)this.request).repository(repository);
        return this;
    }

    public RestoreSnapshotRequestBuilder setIndices(String ... indices) {
        ((RestoreSnapshotRequest)this.request).indices(indices);
        return this;
    }

    public RestoreSnapshotRequestBuilder setIndicesOptions(IndicesOptions indicesOptions) {
        ((RestoreSnapshotRequest)this.request).indicesOptions(indicesOptions);
        return this;
    }

    public RestoreSnapshotRequestBuilder setRenamePattern(String renamePattern) {
        ((RestoreSnapshotRequest)this.request).renamePattern(renamePattern);
        return this;
    }

    public RestoreSnapshotRequestBuilder setRenameReplacement(String renameReplacement) {
        ((RestoreSnapshotRequest)this.request).renameReplacement(renameReplacement);
        return this;
    }

    public RestoreSnapshotRequestBuilder setSettings(Settings settings) {
        ((RestoreSnapshotRequest)this.request).settings(settings);
        return this;
    }

    public RestoreSnapshotRequestBuilder setSettings(Settings.Builder settings) {
        ((RestoreSnapshotRequest)this.request).settings(settings);
        return this;
    }

    public RestoreSnapshotRequestBuilder setSettings(String source) {
        ((RestoreSnapshotRequest)this.request).settings(source);
        return this;
    }

    public RestoreSnapshotRequestBuilder setSettings(Map<String, Object> source) {
        ((RestoreSnapshotRequest)this.request).settings(source);
        return this;
    }

    public RestoreSnapshotRequestBuilder setWaitForCompletion(boolean waitForCompletion) {
        ((RestoreSnapshotRequest)this.request).waitForCompletion(waitForCompletion);
        return this;
    }

    public RestoreSnapshotRequestBuilder setRestoreGlobalState(boolean restoreGlobalState) {
        ((RestoreSnapshotRequest)this.request).includeGlobalState(restoreGlobalState);
        return this;
    }

    public RestoreSnapshotRequestBuilder setPartial(boolean partial) {
        ((RestoreSnapshotRequest)this.request).partial(partial);
        return this;
    }

    public RestoreSnapshotRequestBuilder setIncludeAliases(boolean restoreAliases) {
        ((RestoreSnapshotRequest)this.request).includeAliases(restoreAliases);
        return this;
    }

    public RestoreSnapshotRequestBuilder setIndexSettings(Settings settings) {
        ((RestoreSnapshotRequest)this.request).indexSettings(settings);
        return this;
    }

    public RestoreSnapshotRequestBuilder setIndexSettings(Settings.Builder settings) {
        ((RestoreSnapshotRequest)this.request).indexSettings(settings);
        return this;
    }

    public RestoreSnapshotRequestBuilder setIndexSettings(String source) {
        ((RestoreSnapshotRequest)this.request).indexSettings(source);
        return this;
    }

    public RestoreSnapshotRequestBuilder setIndexSettings(Map<String, Object> source) {
        ((RestoreSnapshotRequest)this.request).indexSettings(source);
        return this;
    }

    public RestoreSnapshotRequestBuilder setIgnoreIndexSettings(String ... ignoreIndexSettings) {
        ((RestoreSnapshotRequest)this.request).ignoreIndexSettings(ignoreIndexSettings);
        return this;
    }

    public RestoreSnapshotRequestBuilder setIgnoreIndexSettings(List<String> ignoreIndexSettings) {
        ((RestoreSnapshotRequest)this.request).ignoreIndexSettings(ignoreIndexSettings);
        return this;
    }

    @Override
    protected void doExecute(ActionListener<RestoreSnapshotResponse> listener) {
        ((ClusterAdminClient)this.client).restoreSnapshot((RestoreSnapshotRequest)this.request, listener);
    }
}

