/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.FilterBuilder;

public class Alias
implements Streamable {
    private String name;
    @Nullable
    private String filter;
    @Nullable
    private String indexRouting;
    @Nullable
    private String searchRouting;

    private Alias() {
    }

    public Alias(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public String filter() {
        return this.filter;
    }

    public Alias filter(String filter) {
        this.filter = filter;
        return this;
    }

    public Alias filter(Map<String, Object> filter) {
        if (filter == null || filter.isEmpty()) {
            this.filter = null;
            return this;
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(filter);
            this.filter = builder.string();
            return this;
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + filter + "]", e);
        }
    }

    public Alias filter(FilterBuilder filterBuilder) {
        if (filterBuilder == null) {
            this.filter = null;
            return this;
        }
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            filterBuilder.toXContent(builder, ToXContent.EMPTY_PARAMS);
            builder.close();
            this.filter = builder.string();
            return this;
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to build json for alias request", e);
        }
    }

    public Alias routing(String routing) {
        this.indexRouting = routing;
        this.searchRouting = routing;
        return this;
    }

    public String indexRouting() {
        return this.indexRouting;
    }

    public Alias indexRouting(String indexRouting) {
        this.indexRouting = indexRouting;
        return this;
    }

    public String searchRouting() {
        return this.searchRouting;
    }

    public Alias searchRouting(String searchRouting) {
        this.searchRouting = searchRouting;
        return this;
    }

    public static Alias read(StreamInput in) throws IOException {
        Alias alias = new Alias();
        alias.readFrom(in);
        return alias;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.filter = in.readOptionalString();
        this.indexRouting = in.readOptionalString();
        this.searchRouting = in.readOptionalString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.filter);
        out.writeOptionalString(this.indexRouting);
        out.writeOptionalString(this.searchRouting);
    }

    public static Alias fromXContent(XContentParser parser) throws IOException {
        Alias alias = new Alias(parser.currentName());
        String currentFieldName = null;
        XContentParser.Token token = parser.nextToken();
        if (token == null) {
            throw new ElasticsearchIllegalArgumentException("No alias is specified");
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (!"filter".equals(currentFieldName)) continue;
                Map<String, Object> filter = parser.mapOrdered();
                alias.filter(filter);
                continue;
            }
            if (token != XContentParser.Token.VALUE_STRING) continue;
            if ("routing".equals(currentFieldName)) {
                alias.routing(parser.text());
                continue;
            }
            if ("index_routing".equals(currentFieldName) || "indexRouting".equals(currentFieldName) || "index-routing".equals(currentFieldName)) {
                alias.indexRouting(parser.text());
                continue;
            }
            if (!"search_routing".equals(currentFieldName) && !"searchRouting".equals(currentFieldName) && !"search-routing".equals(currentFieldName)) continue;
            alias.searchRouting(parser.text());
        }
        return alias;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Alias alias = (Alias)o;
        return !(this.name != null ? !this.name.equals(alias.name) : alias.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

