/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.optimize;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class OptimizeRequest
extends BroadcastOperationRequest<OptimizeRequest> {
    private int maxNumSegments = -1;
    private boolean onlyExpungeDeletes = false;
    private boolean flush = true;
    private boolean force = false;

    public OptimizeRequest(String ... indices) {
        super(indices);
    }

    public OptimizeRequest() {
    }

    public int maxNumSegments() {
        return this.maxNumSegments;
    }

    public OptimizeRequest maxNumSegments(int maxNumSegments) {
        this.maxNumSegments = maxNumSegments;
        return this;
    }

    public boolean onlyExpungeDeletes() {
        return this.onlyExpungeDeletes;
    }

    public OptimizeRequest onlyExpungeDeletes(boolean onlyExpungeDeletes) {
        this.onlyExpungeDeletes = onlyExpungeDeletes;
        return this;
    }

    public boolean flush() {
        return this.flush;
    }

    public OptimizeRequest flush(boolean flush) {
        this.flush = flush;
        return this;
    }

    @Deprecated
    public boolean force() {
        return this.force;
    }

    @Deprecated
    public OptimizeRequest force(boolean force) {
        this.force = force;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().before(Version.V_1_5_0)) {
            in.readBoolean();
        }
        this.maxNumSegments = in.readInt();
        this.onlyExpungeDeletes = in.readBoolean();
        this.flush = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_1_1_0)) {
            this.force = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_1_5_0)) {
            out.writeBoolean(true);
        }
        out.writeInt(this.maxNumSegments);
        out.writeBoolean(this.onlyExpungeDeletes);
        out.writeBoolean(this.flush);
        if (out.getVersion().onOrAfter(Version.V_1_1_0)) {
            out.writeBoolean(this.force);
        }
    }

    public String toString() {
        return "OptimizeRequest{maxNumSegments=" + this.maxNumSegments + ", onlyExpungeDeletes=" + this.onlyExpungeDeletes + ", flush=" + this.flush + ", force=" + this.force + '}';
    }

    public static final class Defaults {
        public static final int MAX_NUM_SEGMENTS = -1;
        public static final boolean ONLY_EXPUNGE_DELETES = false;
        public static final boolean FLUSH = true;
        public static final boolean FORCE = false;
    }
}

