/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.validate.query;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.action.support.broadcast.BroadcastOperationRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;

public class ValidateQueryRequest
extends BroadcastOperationRequest<ValidateQueryRequest> {
    private BytesReference source;
    private boolean explain;
    private boolean rewrite;
    private String[] types = Strings.EMPTY_ARRAY;
    long nowInMillis;

    ValidateQueryRequest() {
        this(Strings.EMPTY_ARRAY);
    }

    public ValidateQueryRequest(String ... indices) {
        super(indices);
        this.indicesOptions(IndicesOptions.fromOptions(false, false, true, false));
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        return validationException;
    }

    public BytesReference source() {
        return this.source;
    }

    public ValidateQueryRequest source(QuerySourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(Requests.CONTENT_TYPE);
        return this;
    }

    public ValidateQueryRequest source(Map source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(source);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public ValidateQueryRequest source(XContentBuilder builder) {
        this.source = builder.bytes();
        return this;
    }

    public ValidateQueryRequest source(String source) {
        this.source = new BytesArray(source);
        return this;
    }

    public ValidateQueryRequest source(byte[] source) {
        return this.source(source, 0, source.length);
    }

    public ValidateQueryRequest source(byte[] source, int offset, int length) {
        return this.source(new BytesArray(source, offset, length));
    }

    public ValidateQueryRequest source(BytesReference source) {
        this.source = source;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public ValidateQueryRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public void explain(boolean explain) {
        this.explain = explain;
    }

    public boolean explain() {
        return this.explain;
    }

    public void rewrite(boolean rewrite) {
        this.rewrite = rewrite;
    }

    public boolean rewrite() {
        return this.rewrite;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.source = in.readBytesReference();
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readString();
            }
        }
        this.explain = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_1_6_0)) {
            this.rewrite = in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBytesReference(this.source);
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeString(type);
        }
        out.writeBoolean(this.explain);
        if (out.getVersion().onOrAfter(Version.V_1_6_0)) {
            out.writeBoolean(this.rewrite);
        }
    }

    public String toString() {
        String sSource = "_na_";
        try {
            sSource = XContentHelper.convertToJson(this.source, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "[" + Arrays.toString(this.indices) + "]" + Arrays.toString(this.types) + ", source[" + sSource + "], explain:" + this.explain + ", rewrite:" + this.rewrite;
    }
}

