/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.RoutingMissingException;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.single.shard.TransportShardSingleOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.operation.plain.Preference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetAction
extends TransportShardSingleOperationAction<GetRequest, GetResponse> {
    private final IndicesService indicesService;
    private final boolean realtime;

    @Inject
    public TransportGetAction(Settings settings, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ThreadPool threadPool, ActionFilters actionFilters) {
        super(settings, "indices:data/read/get", threadPool, clusterService, transportService, actionFilters);
        this.indicesService = indicesService;
        this.realtime = settings.getAsBoolean("action.get.realtime", (Boolean)true);
    }

    @Override
    protected String executor() {
        return "get";
    }

    @Override
    protected boolean resolveIndex() {
        return true;
    }

    @Override
    protected ShardIterator shards(ClusterState state, TransportShardSingleOperationAction.InternalRequest request) {
        return this.clusterService.operationRouting().getShards(this.clusterService.state(), request.concreteIndex(), ((GetRequest)request.request()).type(), ((GetRequest)request.request()).id(), ((GetRequest)request.request()).routing(), ((GetRequest)request.request()).preference());
    }

    @Override
    protected void resolveRequest(ClusterState state, TransportShardSingleOperationAction.InternalRequest request) {
        if (((GetRequest)request.request()).realtime == null) {
            ((GetRequest)request.request()).realtime = this.realtime;
        }
        IndexMetaData indexMeta = state.getMetaData().index(request.concreteIndex());
        if (((GetRequest)request.request()).realtime.booleanValue() && ((GetRequest)request.request()).preference() == null && indexMeta != null && IndexMetaData.isIndexUsingShadowReplicas(indexMeta.settings())) {
            ((GetRequest)request.request()).preference(Preference.PRIMARY.type());
        }
        ((GetRequest)request.request()).routing(state.metaData().resolveIndexRouting(((GetRequest)request.request()).routing(), ((GetRequest)request.request()).index()));
        if (((GetRequest)request.request()).routing() == null && state.getMetaData().routingRequired(request.concreteIndex(), ((GetRequest)request.request()).type())) {
            throw new RoutingMissingException(request.concreteIndex(), ((GetRequest)request.request()).type(), ((GetRequest)request.request()).id());
        }
    }

    @Override
    protected GetResponse shardOperation(GetRequest request, ShardId shardId) throws ElasticsearchException {
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.shardSafe(shardId.id());
        if (request.refresh() && !request.realtime()) {
            indexShard.refresh("refresh_flag_get");
        }
        GetResult result = indexShard.getService().get(request.type(), request.id(), request.fields(), request.realtime(), request.version(), request.versionType(), request.fetchSourceContext(), request.ignoreErrorsOnGeneratedFields());
        return new GetResponse(result);
    }

    @Override
    protected GetRequest newRequest() {
        return new GetRequest();
    }

    @Override
    protected GetResponse newResponse() {
        return new GetResponse();
    }
}

