/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.allocator;

import org.elasticsearch.cluster.routing.allocation.allocator.BalancedShardsAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.EvenShardsCountAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.GatewayAllocator;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocator;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.local.LocalGatewayAllocator;
import org.elasticsearch.gateway.none.NoneGatewayAllocator;

public class ShardsAllocatorModule
extends AbstractModule {
    public static final String EVEN_SHARD_COUNT_ALLOCATOR_KEY = "even_shard";
    public static final String BALANCED_ALLOCATOR_KEY = "balanced";
    public static final String TYPE_KEY = "cluster.routing.allocation.type";
    private Settings settings;
    private Class<? extends ShardsAllocator> shardsAllocator;
    private Class<? extends GatewayAllocator> gatewayAllocator = NoneGatewayAllocator.class;

    public ShardsAllocatorModule(Settings settings) {
        this.settings = settings;
        this.shardsAllocator = this.loadShardsAllocator(settings);
    }

    public void setGatewayAllocator(Class<? extends GatewayAllocator> gatewayAllocator) {
        this.gatewayAllocator = gatewayAllocator;
    }

    public void setShardsAllocator(Class<? extends ShardsAllocator> shardsAllocator) {
        this.shardsAllocator = shardsAllocator;
    }

    @Override
    protected void configure() {
        if (this.shardsAllocator == null) {
            this.shardsAllocator = this.loadShardsAllocator(this.settings);
        }
        this.bind(LocalGatewayAllocator.class).asEagerSingleton();
        this.bind(GatewayAllocator.class).to(this.gatewayAllocator).asEagerSingleton();
        this.bind(ShardsAllocator.class).to(this.shardsAllocator).asEagerSingleton();
    }

    private Class<? extends ShardsAllocator> loadShardsAllocator(Settings settings) {
        String type = settings.get(TYPE_KEY, BALANCED_ALLOCATOR_KEY);
        Class shardsAllocator = BALANCED_ALLOCATOR_KEY.equals(type) ? BalancedShardsAllocator.class : (EVEN_SHARD_COUNT_ALLOCATOR_KEY.equals(type) ? EvenShardsCountAllocator.class : settings.getAsClass(TYPE_KEY, BalancedShardsAllocator.class, "org.elasticsearch.cluster.routing.allocation.allocator.", "Allocator"));
        return shardsAllocator;
    }
}

