/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf.impl;

import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.common.compress.lzf.ChunkDecoder;
import org.elasticsearch.common.compress.lzf.LZFException;

public class VanillaChunkDecoder
extends ChunkDecoder {
    @Override
    public final int decodeChunk(InputStream is, byte[] inputBuffer, byte[] outputBuffer) throws IOException {
        int bytesRead = VanillaChunkDecoder.readHeader(is, inputBuffer);
        if (bytesRead < 5 || inputBuffer[0] != 90 || inputBuffer[1] != 86) {
            if (bytesRead == 0) {
                return -1;
            }
            this._reportCorruptHeader();
        }
        byte type = inputBuffer[2];
        int compLen = VanillaChunkDecoder.uint16(inputBuffer, 3);
        if (type == 0) {
            VanillaChunkDecoder.readFully(is, false, outputBuffer, 0, compLen);
            return compLen;
        }
        VanillaChunkDecoder.readFully(is, true, inputBuffer, 0, 2 + compLen);
        int uncompLen = VanillaChunkDecoder.uint16(inputBuffer, 0);
        this.decodeChunk(inputBuffer, 2, outputBuffer, 0, uncompLen);
        return uncompLen;
    }

    @Override
    public final void decodeChunk(byte[] in, int inPos, byte[] out, int outPos, int outEnd) throws LZFException {
        do {
            int ctrl;
            if ((ctrl = in[inPos++] & 0xFF) < 32) {
                switch (ctrl) {
                    case 31: {
                        out[outPos++] = in[inPos++];
                    }
                    case 30: {
                        out[outPos++] = in[inPos++];
                    }
                    case 29: {
                        out[outPos++] = in[inPos++];
                    }
                    case 28: {
                        out[outPos++] = in[inPos++];
                    }
                    case 27: {
                        out[outPos++] = in[inPos++];
                    }
                    case 26: {
                        out[outPos++] = in[inPos++];
                    }
                    case 25: {
                        out[outPos++] = in[inPos++];
                    }
                    case 24: {
                        out[outPos++] = in[inPos++];
                    }
                    case 23: {
                        out[outPos++] = in[inPos++];
                    }
                    case 22: {
                        out[outPos++] = in[inPos++];
                    }
                    case 21: {
                        out[outPos++] = in[inPos++];
                    }
                    case 20: {
                        out[outPos++] = in[inPos++];
                    }
                    case 19: {
                        out[outPos++] = in[inPos++];
                    }
                    case 18: {
                        out[outPos++] = in[inPos++];
                    }
                    case 17: {
                        out[outPos++] = in[inPos++];
                    }
                    case 16: {
                        out[outPos++] = in[inPos++];
                    }
                    case 15: {
                        out[outPos++] = in[inPos++];
                    }
                    case 14: {
                        out[outPos++] = in[inPos++];
                    }
                    case 13: {
                        out[outPos++] = in[inPos++];
                    }
                    case 12: {
                        out[outPos++] = in[inPos++];
                    }
                    case 11: {
                        out[outPos++] = in[inPos++];
                    }
                    case 10: {
                        out[outPos++] = in[inPos++];
                    }
                    case 9: {
                        out[outPos++] = in[inPos++];
                    }
                    case 8: {
                        out[outPos++] = in[inPos++];
                    }
                    case 7: {
                        out[outPos++] = in[inPos++];
                    }
                    case 6: {
                        out[outPos++] = in[inPos++];
                    }
                    case 5: {
                        out[outPos++] = in[inPos++];
                    }
                    case 4: {
                        out[outPos++] = in[inPos++];
                    }
                    case 3: {
                        out[outPos++] = in[inPos++];
                    }
                    case 2: {
                        out[outPos++] = in[inPos++];
                    }
                    case 1: {
                        out[outPos++] = in[inPos++];
                    }
                    case 0: {
                        out[outPos++] = in[inPos++];
                    }
                }
                continue;
            }
            int len = ctrl >> 5;
            ctrl = -((ctrl & 0x1F) << 8) - 1;
            if (len < 7) {
                out[outPos] = out[outPos++ + (ctrl -= in[inPos++] & 0xFF)];
                out[outPos] = out[outPos++ + ctrl];
                switch (len) {
                    case 6: {
                        out[outPos] = out[outPos++ + ctrl];
                    }
                    case 5: {
                        out[outPos] = out[outPos++ + ctrl];
                    }
                    case 4: {
                        out[outPos] = out[outPos++ + ctrl];
                    }
                    case 3: {
                        out[outPos] = out[outPos++ + ctrl];
                    }
                    case 2: {
                        out[outPos] = out[outPos++ + ctrl];
                    }
                    case 1: {
                        out[outPos] = out[outPos++ + ctrl];
                    }
                }
                continue;
            }
            if ((ctrl -= in[inPos++] & 0xFF) + (len = in[inPos++] & 0xFF) < -9) {
                if ((len += 9) <= 32) {
                    VanillaChunkDecoder.copyUpTo32WithSwitch(out, outPos + ctrl, out, outPos, len - 1);
                } else {
                    System.arraycopy(out, outPos + ctrl, out, outPos, len);
                }
                outPos += len;
                continue;
            }
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            out[outPos] = out[outPos++ + ctrl];
            int end = (len += outPos) - 3;
            while (outPos < end) {
                out[outPos] = out[outPos++ + ctrl];
                out[outPos] = out[outPos++ + ctrl];
                out[outPos] = out[outPos++ + ctrl];
                out[outPos] = out[outPos++ + ctrl];
            }
            switch (len - outPos) {
                case 3: {
                    out[outPos] = out[outPos++ + ctrl];
                }
                case 2: {
                    out[outPos] = out[outPos++ + ctrl];
                }
                case 1: {
                    out[outPos] = out[outPos++ + ctrl];
                }
            }
        } while (outPos < outEnd);
        if (outPos != outEnd) {
            throw new LZFException("Corrupt data: overrun in decompress, input offset " + inPos + ", output offset " + outPos);
        }
    }

    @Override
    public int skipOrDecodeChunk(InputStream is, byte[] inputBuffer, byte[] outputBuffer, long maxToSkip) throws IOException {
        int bytesRead = VanillaChunkDecoder.readHeader(is, inputBuffer);
        if (bytesRead < 5 || inputBuffer[0] != 90 || inputBuffer[1] != 86) {
            if (bytesRead == 0) {
                return -1;
            }
            this._reportCorruptHeader();
        }
        byte type = inputBuffer[2];
        int compLen = VanillaChunkDecoder.uint16(inputBuffer, 3);
        if (type == 0) {
            if ((long)compLen <= maxToSkip) {
                VanillaChunkDecoder.skipFully(is, compLen);
                return compLen;
            }
            VanillaChunkDecoder.readFully(is, false, outputBuffer, 0, compLen);
            return -(compLen + 1);
        }
        VanillaChunkDecoder.readFully(is, true, inputBuffer, 0, 2);
        int uncompLen = VanillaChunkDecoder.uint16(inputBuffer, 0);
        if ((long)uncompLen <= maxToSkip) {
            VanillaChunkDecoder.skipFully(is, compLen);
            return uncompLen;
        }
        VanillaChunkDecoder.readFully(is, true, inputBuffer, 2, compLen);
        this.decodeChunk(inputBuffer, 2, outputBuffer, 0, uncompLen);
        return -(uncompLen + 1);
    }

    protected static final void copyUpTo32WithSwitch(byte[] in, int inPos, byte[] out, int outPos, int lengthMinusOne) {
        switch (lengthMinusOne) {
            case 31: {
                out[outPos++] = in[inPos++];
            }
            case 30: {
                out[outPos++] = in[inPos++];
            }
            case 29: {
                out[outPos++] = in[inPos++];
            }
            case 28: {
                out[outPos++] = in[inPos++];
            }
            case 27: {
                out[outPos++] = in[inPos++];
            }
            case 26: {
                out[outPos++] = in[inPos++];
            }
            case 25: {
                out[outPos++] = in[inPos++];
            }
            case 24: {
                out[outPos++] = in[inPos++];
            }
            case 23: {
                out[outPos++] = in[inPos++];
            }
            case 22: {
                out[outPos++] = in[inPos++];
            }
            case 21: {
                out[outPos++] = in[inPos++];
            }
            case 20: {
                out[outPos++] = in[inPos++];
            }
            case 19: {
                out[outPos++] = in[inPos++];
            }
            case 18: {
                out[outPos++] = in[inPos++];
            }
            case 17: {
                out[outPos++] = in[inPos++];
            }
            case 16: {
                out[outPos++] = in[inPos++];
            }
            case 15: {
                out[outPos++] = in[inPos++];
            }
            case 14: {
                out[outPos++] = in[inPos++];
            }
            case 13: {
                out[outPos++] = in[inPos++];
            }
            case 12: {
                out[outPos++] = in[inPos++];
            }
            case 11: {
                out[outPos++] = in[inPos++];
            }
            case 10: {
                out[outPos++] = in[inPos++];
            }
            case 9: {
                out[outPos++] = in[inPos++];
            }
            case 8: {
                out[outPos++] = in[inPos++];
            }
            case 7: {
                out[outPos++] = in[inPos++];
            }
            case 6: {
                out[outPos++] = in[inPos++];
            }
            case 5: {
                out[outPos++] = in[inPos++];
            }
            case 4: {
                out[outPos++] = in[inPos++];
            }
            case 3: {
                out[outPos++] = in[inPos++];
            }
            case 2: {
                out[outPos++] = in[inPos++];
            }
            case 1: {
                out[outPos++] = in[inPos++];
            }
            case 0: {
                out[outPos++] = in[inPos++];
            }
        }
    }
}

