/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.ipfilter;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import org.elasticsearch.common.netty.handler.ipfilter.IpFilterRule;
import org.elasticsearch.common.netty.logging.InternalLogger;
import org.elasticsearch.common.netty.logging.InternalLoggerFactory;
import org.elasticsearch.common.netty.util.internal.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternRule
implements IpFilterRule,
Comparable<Object> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PatternRule.class);
    private Pattern ipPattern;
    private Pattern namePattern;
    private boolean isAllowRule = true;
    private boolean localhost;
    private final String pattern;

    public PatternRule(boolean allow, String pattern) {
        this.isAllowRule = allow;
        this.pattern = pattern;
        this.parse(pattern);
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isAllowRule() {
        return this.isAllowRule;
    }

    @Override
    public boolean isDenyRule() {
        return !this.isAllowRule;
    }

    @Override
    public boolean contains(InetAddress inetAddress) {
        if (this.localhost && PatternRule.isLocalhost(inetAddress)) {
            return true;
        }
        if (this.ipPattern != null && this.ipPattern.matcher(inetAddress.getHostAddress()).matches()) {
            return true;
        }
        return this.namePattern != null && this.namePattern.matcher(inetAddress.getHostName()).matches();
    }

    private void parse(String pattern) {
        if (pattern == null) {
            return;
        }
        String[] acls = StringUtil.split(pattern, ',');
        String ip = "";
        String name = "";
        for (String c : acls) {
            if ("n:localhost".equals(c = c.trim())) {
                this.localhost = true;
                continue;
            }
            if (c.startsWith("n:")) {
                name = PatternRule.addRule(name, c.substring(2));
                continue;
            }
            if (!c.startsWith("i:")) continue;
            ip = PatternRule.addRule(ip, c.substring(2));
        }
        if (ip.length() != 0) {
            this.ipPattern = Pattern.compile(ip);
        }
        if (name.length() != 0) {
            this.namePattern = Pattern.compile(name);
        }
    }

    private static String addRule(String pattern, String rule) {
        if (rule == null || rule.length() == 0) {
            return pattern;
        }
        if (pattern.length() != 0) {
            pattern = pattern + "|";
        }
        rule = rule.replaceAll("\\.", "\\\\.");
        rule = rule.replaceAll("\\*", ".*");
        rule = rule.replaceAll("\\?", ".");
        pattern = pattern + '(' + rule + ')';
        return pattern;
    }

    private static boolean isLocalhost(InetAddress address) {
        block7: {
            block6: {
                try {
                    if (address.equals(InetAddress.getLocalHost())) {
                        return true;
                    }
                }
                catch (UnknownHostException e) {
                    if (!logger.isInfoEnabled()) break block6;
                    logger.info("error getting ip of localhost", e);
                }
            }
            try {
                InetAddress[] addrs;
                for (InetAddress addr : addrs = InetAddress.getAllByName("127.0.0.1")) {
                    if (!addr.equals(address)) continue;
                    return true;
                }
            }
            catch (UnknownHostException e) {
                if (!logger.isInfoEnabled()) break block7;
                logger.info("error getting ip of localhost", e);
            }
        }
        return false;
    }

    @Override
    public int compareTo(Object o) {
        if (o == null) {
            return -1;
        }
        if (!(o instanceof PatternRule)) {
            return -1;
        }
        PatternRule p = (PatternRule)o;
        if (p.isAllowRule() && !this.isAllowRule) {
            return -1;
        }
        if (this.pattern == null && p.pattern == null) {
            return 0;
        }
        if (this.pattern != null) {
            return this.pattern.compareTo(p.getPattern());
        }
        return -1;
    }
}

