/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.KeyedLock;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.BytesBinaryDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.DisabledIndexFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.DoubleArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.FSTBytesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.FloatArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointBinaryDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointCompressedIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointDoubleArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.IndexIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PackedArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.ParentChildIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCacheListener;

public class IndexFieldDataService
extends AbstractIndexComponent {
    public static final String FIELDDATA_CACHE_KEY = "index.fielddata.cache";
    public static final String FIELDDATA_CACHE_VALUE_SOFT = "soft";
    public static final String FIELDDATA_CACHE_VALUE_NODE = "node";
    public static final String FIELDDATA_CACHE_VALUE_RESIDENT = "resident";
    private static final String DISABLED_FORMAT = "disabled";
    private static final String DOC_VALUES_FORMAT = "doc_values";
    private static final String ARRAY_FORMAT = "array";
    private static final String PAGED_BYTES_FORMAT = "paged_bytes";
    private static final String FST_FORMAT = "fst";
    private static final String COMPRESSED_FORMAT = "compressed";
    private static final ImmutableMap<String, IndexFieldData.Builder> buildersByType = MapBuilder.newMapBuilder().put("string", new PagedBytesIndexFieldData.Builder()).put("float", (PagedBytesIndexFieldData.Builder)((Object)new FloatArrayIndexFieldData.Builder())).put("double", (PagedBytesIndexFieldData.Builder)((Object)new DoubleArrayIndexFieldData.Builder())).put("byte", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.BYTE))).put("short", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.SHORT))).put("int", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.INT))).put("long", (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.LONG))).put("geo_point", (PagedBytesIndexFieldData.Builder)((Object)new GeoPointDoubleArrayIndexFieldData.Builder())).put("_parent", (PagedBytesIndexFieldData.Builder)((Object)new ParentChildIndexFieldData.Builder())).put("_index", (PagedBytesIndexFieldData.Builder)((Object)new IndexIndexFieldData.Builder())).put("binary", (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).immutableMap();
    private static final ImmutableMap<String, IndexFieldData.Builder> docValuesBuildersByType = MapBuilder.newMapBuilder().put("string", new DocValuesIndexFieldData.Builder()).put("float", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.FLOAT)).put("double", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.DOUBLE)).put("byte", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.BYTE)).put("short", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.SHORT)).put("int", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.INT)).put("long", new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.LONG)).put("geo_point", (DocValuesIndexFieldData.Builder)((Object)new GeoPointBinaryDVIndexFieldData.Builder())).put("binary", (DocValuesIndexFieldData.Builder)((Object)new BytesBinaryDVIndexFieldData.Builder())).immutableMap();
    private static final ImmutableMap<Tuple<String, String>, IndexFieldData.Builder> buildersByTypeAndFormat = MapBuilder.newMapBuilder().put(Tuple.tuple("string", "paged_bytes"), new PagedBytesIndexFieldData.Builder()).put(Tuple.tuple("string", "fst"), (PagedBytesIndexFieldData.Builder)((Object)new FSTBytesIndexFieldData.Builder())).put(Tuple.tuple("string", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder())).put(Tuple.tuple("string", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("float", "array"), (PagedBytesIndexFieldData.Builder)((Object)new FloatArrayIndexFieldData.Builder())).put(Tuple.tuple("float", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.FLOAT))).put(Tuple.tuple("float", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("double", "array"), (PagedBytesIndexFieldData.Builder)((Object)new DoubleArrayIndexFieldData.Builder())).put(Tuple.tuple("double", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.DOUBLE))).put(Tuple.tuple("double", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("byte", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.BYTE))).put(Tuple.tuple("byte", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.BYTE))).put(Tuple.tuple("byte", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("short", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.SHORT))).put(Tuple.tuple("short", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.SHORT))).put(Tuple.tuple("short", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("int", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.INT))).put(Tuple.tuple("int", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.INT))).put(Tuple.tuple("int", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("long", "array"), (PagedBytesIndexFieldData.Builder)((Object)new PackedArrayIndexFieldData.Builder().setNumericType(IndexNumericFieldData.NumericType.LONG))).put(Tuple.tuple("long", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new DocValuesIndexFieldData.Builder().numericType(IndexNumericFieldData.NumericType.LONG))).put(Tuple.tuple("long", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "array"), (PagedBytesIndexFieldData.Builder)((Object)new GeoPointDoubleArrayIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new GeoPointBinaryDVIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).put(Tuple.tuple("geo_point", "compressed"), (PagedBytesIndexFieldData.Builder)((Object)new GeoPointCompressedIndexFieldData.Builder())).put(Tuple.tuple("binary", "doc_values"), (PagedBytesIndexFieldData.Builder)((Object)new BytesBinaryDVIndexFieldData.Builder())).put(Tuple.tuple("binary", "disabled"), (PagedBytesIndexFieldData.Builder)((Object)new DisabledIndexFieldData.Builder())).immutableMap();
    private final CircuitBreakerService circuitBreakerService;
    private final IndicesFieldDataCacheListener indicesFieldDataCacheListener;
    private final IndicesFieldDataCache indicesFieldDataCache;
    private final ConcurrentMap<String, IndexFieldData<?>> loadedFieldData = ConcurrentCollections.newConcurrentMap();
    private final KeyedLock.GlobalLockable<String> fieldLoadingLock = new KeyedLock.GlobalLockable();
    private final Map<String, IndexFieldDataCache> fieldDataCaches = Maps.newHashMap();
    IndexService indexService;

    @Inject
    public IndexFieldDataService(Index index, @IndexSettings Settings indexSettings, IndicesFieldDataCache indicesFieldDataCache, CircuitBreakerService circuitBreakerService, IndicesFieldDataCacheListener indicesFieldDataCacheListener) {
        super(index, indexSettings);
        this.indicesFieldDataCache = indicesFieldDataCache;
        this.circuitBreakerService = circuitBreakerService;
        this.indicesFieldDataCacheListener = indicesFieldDataCacheListener;
    }

    public void setIndexService(IndexService indexService) {
        this.indexService = indexService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.fieldLoadingLock.globalLock().lock();
        try {
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>(0);
            Collection fieldDataValues = this.loadedFieldData.values();
            for (IndexFieldData fieldData : fieldDataValues) {
                try {
                    fieldData.clear();
                }
                catch (Throwable t) {
                    exceptions.add(t);
                }
            }
            fieldDataValues.clear();
            Collection<IndexFieldDataCache> fieldDataCacheValues = this.fieldDataCaches.values();
            for (IndexFieldDataCache cache : fieldDataCacheValues) {
                try {
                    cache.clear();
                }
                catch (Throwable t) {
                    exceptions.add(t);
                }
            }
            fieldDataCacheValues.clear();
            ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
        }
        finally {
            this.fieldLoadingLock.globalLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearField(String fieldName) {
        this.fieldLoadingLock.acquire(fieldName);
        try {
            IndexFieldDataCache cache;
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>(0);
            IndexFieldData fieldData = (IndexFieldData)this.loadedFieldData.remove(fieldName);
            if (fieldData != null) {
                try {
                    fieldData.clear();
                }
                catch (Throwable t) {
                    exceptions.add(t);
                }
            }
            if ((cache = this.fieldDataCaches.remove(fieldName)) != null) {
                try {
                    cache.clear();
                }
                catch (Throwable t) {
                    exceptions.add(t);
                }
            }
            ExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
        }
        finally {
            this.fieldLoadingLock.release(fieldName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMappingUpdate() {
        this.fieldLoadingLock.globalLock().lock();
        try {
            this.loadedFieldData.clear();
        }
        finally {
            this.fieldLoadingLock.globalLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <IFD extends IndexFieldData<?>> IFD getForField(FieldMapper<?> mapper) {
        FieldMapper.Names fieldNames = mapper.names();
        FieldDataType type = mapper.fieldDataType();
        if (type == null) {
            throw new ElasticsearchIllegalArgumentException("found no fielddata type for field [" + fieldNames.fullName() + "]");
        }
        boolean docValues = mapper.hasDocValues();
        String key = fieldNames.indexName();
        IndexFieldData<?> fieldData = (IndexFieldData<?>)this.loadedFieldData.get(key);
        if (fieldData == null) {
            this.fieldLoadingLock.acquire(key);
            try {
                fieldData = (IndexFieldData)this.loadedFieldData.get(key);
                if (fieldData == null) {
                    IndexFieldData.Builder builder = null;
                    String format = type.getFormat(this.indexSettings);
                    if (format != null && DOC_VALUES_FORMAT.equals(format) && !docValues) {
                        this.logger.warn("field [" + fieldNames.fullName() + "] has no doc values, will use default field data format", new Object[0]);
                        format = null;
                    }
                    if (format != null && (builder = buildersByTypeAndFormat.get(Tuple.tuple(type.getType(), format))) == null) {
                        this.logger.warn("failed to find format [" + format + "] for field [" + fieldNames.fullName() + "], will use default", new Object[0]);
                    }
                    if (builder == null && docValues) {
                        builder = docValuesBuildersByType.get(type.getType());
                    }
                    if (builder == null) {
                        builder = buildersByType.get(type.getType());
                    }
                    if (builder == null) {
                        throw new ElasticsearchIllegalArgumentException("failed to find field data builder for field " + fieldNames.fullName() + ", and type " + type.getType());
                    }
                    IndexFieldDataCache cache = this.fieldDataCaches.get(fieldNames.indexName());
                    if (cache == null) {
                        boolean pre14 = Version.indexCreated(this.indexSettings).before(Version.V_1_4_0_Beta1);
                        String cacheType = type.getSettings().get("cache", this.indexSettings.get(FIELDDATA_CACHE_KEY, FIELDDATA_CACHE_VALUE_NODE));
                        if (pre14 && FIELDDATA_CACHE_VALUE_RESIDENT.equals(cacheType)) {
                            cache = new IndexFieldDataCache.Resident(this.logger, this.indexService, fieldNames, type, this.indicesFieldDataCacheListener);
                            this.logger.warn("index.fielddata.cache=resident is deprecated and will not be usable for indices created on or after elasticsearch 1.4.0", new Object[0]);
                        } else if (pre14 && FIELDDATA_CACHE_VALUE_SOFT.equals(cacheType)) {
                            cache = new IndexFieldDataCache.Soft(this.logger, this.indexService, fieldNames, type, this.indicesFieldDataCacheListener);
                            this.logger.warn("index.fielddata.cache=soft is deprecated and will not be usable for indices created on or after elasticsearch 1.4.0", new Object[0]);
                        } else if (FIELDDATA_CACHE_VALUE_NODE.equals(cacheType)) {
                            cache = this.indicesFieldDataCache.buildIndexFieldDataCache(this.indexService, this.index, fieldNames, type);
                        } else if ("none".equals(cacheType)) {
                            cache = new IndexFieldDataCache.None();
                        } else {
                            throw new ElasticsearchIllegalArgumentException("cache type not supported [" + cacheType + "] for field [" + fieldNames.fullName() + "]");
                        }
                        this.fieldDataCaches.put(fieldNames.indexName(), cache);
                    }
                    fieldData = builder.build(this.index, this.indexSettings, mapper, cache, this.circuitBreakerService, this.indexService.mapperService());
                    this.loadedFieldData.put(fieldNames.indexName(), fieldData);
                }
            }
            finally {
                this.fieldLoadingLock.release(key);
            }
        }
        return (IFD)fieldData;
    }
}

