/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.BinaryDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.BinaryDVNumericIndexFieldData;
import org.elasticsearch.index.fielddata.plain.NumericDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedNumericDVIndexFieldData;
import org.elasticsearch.index.fielddata.plain.SortedSetDVOrdinalsIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;

public abstract class DocValuesIndexFieldData {
    protected final Index index;
    protected final FieldMapper.Names fieldNames;
    protected final FieldDataType fieldDataType;
    protected final ESLogger logger;

    public DocValuesIndexFieldData(Index index, FieldMapper.Names fieldNames, FieldDataType fieldDataType) {
        this.index = index;
        this.fieldNames = fieldNames;
        this.fieldDataType = fieldDataType;
        this.logger = Loggers.getLogger(this.getClass());
    }

    public final FieldMapper.Names getFieldNames() {
        return this.fieldNames;
    }

    public final FieldDataType getFieldDataType() {
        return this.fieldDataType;
    }

    public final void clear() {
    }

    public final void clear(IndexReader reader) {
    }

    public final Index index() {
        return this.index;
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private static final Set<String> BINARY_INDEX_FIELD_NAMES = ImmutableSet.of("_uid", "_id");
        private static final Set<String> NUMERIC_INDEX_FIELD_NAMES = ImmutableSet.of("_timestamp");
        private IndexNumericFieldData.NumericType numericType;

        public Builder numericType(IndexNumericFieldData.NumericType type) {
            this.numericType = type;
            return this;
        }

        @Override
        public IndexFieldData<?> build(Index index, Settings indexSettings, FieldMapper<?> mapper, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            FieldMapper.Names fieldNames = mapper.names();
            Settings fdSettings = mapper.fieldDataType().getSettings();
            Map<String, Settings> filter = fdSettings.getGroups("filter");
            if (filter != null && !filter.isEmpty()) {
                throw new ElasticsearchIllegalArgumentException("Doc values field data doesn't support filters [" + fieldNames.name() + "]");
            }
            if (BINARY_INDEX_FIELD_NAMES.contains(fieldNames.indexName())) {
                assert (this.numericType == null);
                return new BinaryDVIndexFieldData(index, fieldNames, mapper.fieldDataType());
            }
            if (NUMERIC_INDEX_FIELD_NAMES.contains(fieldNames.indexName())) {
                assert (!this.numericType.isFloatingPoint());
                return new NumericDVIndexFieldData(index, fieldNames, mapper.fieldDataType());
            }
            if (this.numericType != null) {
                if (Version.indexCreated(indexSettings).onOrAfter(Version.V_1_4_0_Beta1)) {
                    return new SortedNumericDVIndexFieldData(index, fieldNames, this.numericType, mapper.fieldDataType());
                }
                return new BinaryDVNumericIndexFieldData(index, fieldNames, this.numericType, mapper.fieldDataType());
            }
            return new SortedSetDVOrdinalsIndexFieldData(index, cache, indexSettings, fieldNames, breakerService, mapper.fieldDataType());
        }
    }
}

