/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.EnabledAttributeMapper;

public class IndexFieldMapper
extends AbstractFieldMapper<String>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_index";
    public static final String CONTENT_TYPE = "_index";
    private EnabledAttributeMapper enabledState;

    public IndexFieldMapper() {
        this("_index", "_index");
    }

    protected IndexFieldMapper(String name, String indexName) {
        this(name, indexName, 1.0f, new FieldType(Defaults.FIELD_TYPE), null, Defaults.ENABLED_STATE, null, null, null, ImmutableSettings.EMPTY);
    }

    public IndexFieldMapper(String name, String indexName, float boost, FieldType fieldType, Boolean docValues, EnabledAttributeMapper enabledState, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, @Nullable Settings fieldDataSettings, Settings indexSettings) {
        super(new FieldMapper.Names(name, indexName, indexName, name), boost, fieldType, docValues, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER, postingsProvider, docValuesProvider, null, null, fieldDataSettings, indexSettings);
        this.enabledState = enabledState;
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("_index");
    }

    @Override
    public boolean hasDocValues() {
        return false;
    }

    public String value(Document document) {
        Field field = (Field)document.getField(this.names.indexName());
        return field == null ? null : this.value(field);
    }

    @Override
    public String value(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public boolean includeInObject() {
        return false;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (!this.enabledState.enabled) {
            return;
        }
        fields.add(new Field(this.names.indexName(), context.index(), this.fieldType));
    }

    @Override
    protected String contentType() {
        return "_index";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults && this.fieldType().stored() == Defaults.FIELD_TYPE.stored() && this.enabledState == Defaults.ENABLED_STATE && this.customFieldDataSettings == null) {
            return builder;
        }
        builder.startObject("_index");
        if (includeDefaults || this.fieldType().stored() != Defaults.FIELD_TYPE.stored()) {
            builder.field("store", this.fieldType().stored());
        }
        if (includeDefaults || this.enabledState != Defaults.ENABLED_STATE) {
            builder.field("enabled", this.enabledState.enabled);
        }
        if (this.customFieldDataSettings != null) {
            builder.field("fielddata", this.customFieldDataSettings.getAsMap());
        } else if (includeDefaults) {
            builder.field("fielddata", this.fieldDataType.getSettings().getAsMap());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        IndexFieldMapper indexFieldMapperMergeWith = (IndexFieldMapper)mergeWith;
        if (!mergeContext.mergeFlags().simulate() && indexFieldMapperMergeWith.enabledState != this.enabledState && !indexFieldMapperMergeWith.enabledState.unset()) {
            this.enabledState = indexFieldMapperMergeWith.enabledState;
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.index();
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("enabled")) continue;
                EnabledAttributeMapper mapper = XContentMapValues.nodeBooleanValue(fieldNode) ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED;
                builder.enabled(mapper);
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, IndexFieldMapper> {
        private EnabledAttributeMapper enabledState = EnabledAttributeMapper.UNSET_DISABLED;

        public Builder() {
            super("_index", new FieldType(Defaults.FIELD_TYPE));
            this.indexName = "_index";
        }

        public Builder enabled(EnabledAttributeMapper enabledState) {
            this.enabledState = enabledState;
            return this;
        }

        @Override
        public IndexFieldMapper build(Mapper.BuilderContext context) {
            return new IndexFieldMapper(this.name, this.indexName, this.boost, this.fieldType, this.docValues, this.enabledState, this.postingsProvider, this.docValuesProvider, this.fieldDataSettings, context.indexSettings());
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_index";
        public static final String INDEX_NAME = "_index";
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);
        public static final EnabledAttributeMapper ENABLED_STATE;

        static {
            FIELD_TYPE.setIndexed(true);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_ONLY);
            FIELD_TYPE.freeze();
            ENABLED_STATE = EnabledAttributeMapper.UNSET_DISABLED;
        }
    }
}

