/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class GeoShapeQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<GeoShapeQueryBuilder> {
    private final String name;
    private SpatialStrategy strategy = null;
    private final ShapeBuilder shape;
    private float boost = -1.0f;
    private final String indexedShapeId;
    private final String indexedShapeType;
    private String indexedShapeIndex;
    private String indexedShapePath;
    private String queryName;

    public GeoShapeQueryBuilder(String name, ShapeBuilder shape) {
        this(name, shape, null, null);
    }

    public GeoShapeQueryBuilder(String name, String indexedShapeId, String indexedShapeType) {
        this(name, null, indexedShapeId, indexedShapeType);
    }

    private GeoShapeQueryBuilder(String name, ShapeBuilder shape, String indexedShapeId, String indexedShapeType) {
        this.name = name;
        this.shape = shape;
        this.indexedShapeId = indexedShapeId;
        this.indexedShapeType = indexedShapeType;
    }

    @Override
    public GeoShapeQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public GeoShapeQueryBuilder strategy(SpatialStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public GeoShapeQueryBuilder indexedShapeIndex(String indexedShapeIndex) {
        this.indexedShapeIndex = indexedShapeIndex;
        return this;
    }

    public GeoShapeQueryBuilder indexedShapePath(String indexedShapePath) {
        this.indexedShapePath = indexedShapePath;
        return this;
    }

    public GeoShapeQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("geo_shape");
        builder.startObject(this.name);
        if (this.strategy != null) {
            builder.field("strategy", this.strategy.getStrategyName());
        }
        if (this.shape != null) {
            builder.field("shape", this.shape);
        } else {
            builder.startObject("indexed_shape").field("id", this.indexedShapeId).field("type", this.indexedShapeType);
            if (this.indexedShapeIndex != null) {
                builder.field("index", this.indexedShapeIndex);
            }
            if (this.indexedShapePath != null) {
                builder.field("path", this.indexedShapePath);
            }
            builder.endObject();
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
        builder.endObject();
    }
}

