/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class TranslogStats
implements ToXContent,
Streamable {
    private long translogSizeInBytes = 0L;
    private int estimatedNumberOfOperations = 0;

    public TranslogStats() {
    }

    public TranslogStats(int estimatedNumberOfOperations, long translogSizeInBytes) {
        assert (estimatedNumberOfOperations >= 0) : "estimatedNumberOfOperations must be >=0, got [" + estimatedNumberOfOperations + "]";
        assert (translogSizeInBytes >= 0L) : "translogSizeInBytes must be >=0, got [" + translogSizeInBytes + "]";
        this.estimatedNumberOfOperations = estimatedNumberOfOperations;
        this.translogSizeInBytes = translogSizeInBytes;
    }

    public void add(TranslogStats translogStats) {
        if (translogStats == null) {
            return;
        }
        this.estimatedNumberOfOperations += translogStats.estimatedNumberOfOperations;
        this.translogSizeInBytes = translogStats.translogSizeInBytes;
    }

    public ByteSizeValue translogSizeInBytes() {
        return new ByteSizeValue(this.translogSizeInBytes);
    }

    public long estimatedNumberOfOperations() {
        return this.estimatedNumberOfOperations;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.TRANSLOG);
        builder.field(Fields.OPERATIONS, this.estimatedNumberOfOperations);
        builder.byteSizeField(Fields.SIZE_IN_BYTES, Fields.SIZE, this.translogSizeInBytes);
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.estimatedNumberOfOperations = in.readVInt();
        if (in.getVersion().onOrAfter(Version.V_1_4_5)) {
            this.translogSizeInBytes = in.readVLong();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.estimatedNumberOfOperations);
        if (out.getVersion().onOrAfter(Version.V_1_4_5)) {
            out.writeVLong(this.translogSizeInBytes);
        }
    }

    static final class Fields {
        static final XContentBuilderString TRANSLOG = new XContentBuilderString("translog");
        static final XContentBuilderString OPERATIONS = new XContentBuilderString("operations");
        static final XContentBuilderString SIZE = new XContentBuilderString("size");
        static final XContentBuilderString SIZE_IN_BYTES = new XContentBuilderString("size_in_bytes");

        Fields() {
        }
    }
}

