/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.transport.TransportService;

public class SharedFSRecoverySourceHandler
extends RecoverySourceHandler {
    private final IndexShard shard;
    private final StartRecoveryRequest request;
    private final AtomicBoolean engineClosed = new AtomicBoolean(false);

    public SharedFSRecoverySourceHandler(IndexShard shard, StartRecoveryRequest request, RecoverySettings recoverySettings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, MappingUpdatedAction mappingUpdatedAction, ESLogger logger) {
        super(shard, request, recoverySettings, transportService, clusterService, indicesService, mappingUpdatedAction, logger);
        this.shard = shard;
        this.request = request;
    }

    @Override
    public void phase1(SnapshotIndexCommit snapshot) throws ElasticsearchException {
        this.logger.trace("{} recovery [phase1] to {}: skipping phase 1 for shared filesystem", this.request.shardId(), this.request.targetNode());
        if (this.isPrimaryRelocation()) {
            this.logger.debug("[phase1] closing engine on primary for shared filesystem recovery", new Object[0]);
            this.shard.engine().flush(true, true);
            try {
                this.shard.engine().close();
                this.engineClosed.set(true);
            }
            catch (IOException e) {
                this.logger.warn("close engine failed", e, new Object[0]);
                this.shard.failShard("failed to close engine (phase1)", e);
            }
        }
    }

    @Override
    public void phase2(Translog.Snapshot snapshot) throws ElasticsearchException {
        try {
            super.phase2(snapshot);
        }
        catch (Throwable t) {
            this.onRecoveryFailure(t);
            throw t;
        }
    }

    @Override
    public void phase3(Translog.Snapshot snapshot) throws ElasticsearchException {
        try {
            super.phase3(snapshot);
        }
        catch (Throwable t) {
            this.onRecoveryFailure(t);
            throw t;
        }
    }

    @Override
    protected int sendSnapshot(Translog.Snapshot snapshot) throws ElasticsearchException {
        this.logger.trace("{} skipping recovery of translog snapshot on shared filesystem to: {}", this.shard.shardId(), this.request.targetNode());
        return 0;
    }

    private boolean isPrimaryRelocation() {
        return this.request.recoveryType() == RecoveryState.Type.RELOCATION && this.shard.routingEntry().primary();
    }

    public void onRecoveryFailure(Throwable t) {
        if (this.isPrimaryRelocation() && this.engineClosed.get()) {
            this.logger.info("recovery failed for primary shadow shard, failing shard", new Object[0]);
            this.shard.failShard("primary relocation failed on shared filesystem caused by: [" + t.getMessage() + "]", null);
        } else {
            this.logger.info("recovery failed on shared filesystem", t, new Object[0]);
        }
    }
}

