/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.fs;

import java.io.File;
import java.util.Map;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.monitor.fs.FsProbe;
import org.elasticsearch.monitor.fs.FsStats;
import org.elasticsearch.monitor.sigar.SigarService;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class SigarFsProbe
extends AbstractComponent
implements FsProbe {
    private final NodeEnvironment nodeEnv;
    private final SigarService sigarService;
    private Map<File, FileSystem> fileSystems = Maps.newHashMap();

    @Inject
    public SigarFsProbe(Settings settings, NodeEnvironment nodeEnv, SigarService sigarService) {
        super(settings);
        this.nodeEnv = nodeEnv;
        this.sigarService = sigarService;
    }

    @Override
    public synchronized FsStats stats() {
        if (!this.nodeEnv.hasNodeFile()) {
            return new FsStats(System.currentTimeMillis(), new FsStats.Info[0]);
        }
        NodeEnvironment.NodePath[] nodePaths = this.nodeEnv.nodePaths();
        FsStats.Info[] infos = new FsStats.Info[nodePaths.length];
        for (int i = 0; i < nodePaths.length; ++i) {
            NodeEnvironment.NodePath nodePath = nodePaths[i];
            File dataLocation = nodePath.path.toFile();
            FsStats.Info info = new FsStats.Info();
            info.path = dataLocation.getAbsolutePath();
            try {
                FileSystemMap fileSystemMap;
                FileSystem fileSystem = this.fileSystems.get(dataLocation);
                Sigar sigar = this.sigarService.sigar();
                if (fileSystem == null && (fileSystemMap = sigar.getFileSystemMap()) != null) {
                    fileSystem = fileSystemMap.getMountPoint(dataLocation.getPath());
                    this.fileSystems.put(dataLocation, fileSystem);
                }
                if (fileSystem != null) {
                    info.mount = fileSystem.getDirName();
                    info.dev = fileSystem.getDevName();
                    info.type = fileSystem.getSysTypeName();
                    FileSystemUsage fileSystemUsage = sigar.getFileSystemUsage(fileSystem.getDirName());
                    if (fileSystemUsage != null) {
                        info.total = fileSystemUsage.getTotal() * 1024L;
                        info.free = fileSystemUsage.getFree() * 1024L;
                        info.available = fileSystemUsage.getAvail() * 1024L;
                        info.diskReads = fileSystemUsage.getDiskReads();
                        info.diskWrites = fileSystemUsage.getDiskWrites();
                        info.diskReadBytes = fileSystemUsage.getDiskReadBytes();
                        info.diskWriteBytes = fileSystemUsage.getDiskWriteBytes();
                        info.diskQueue = fileSystemUsage.getDiskQueue();
                        info.diskServiceTime = fileSystemUsage.getDiskServiceTime();
                    }
                }
            }
            catch (SigarException e) {
                // empty catch block
            }
            infos[i] = info;
        }
        return new FsStats(System.currentTimeMillis(), infos);
    }
}

