/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.network;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.SingleObjectCache;
import org.elasticsearch.monitor.network.NetworkInfo;
import org.elasticsearch.monitor.network.NetworkProbe;
import org.elasticsearch.monitor.network.NetworkStats;

public final class NetworkService
extends AbstractComponent {
    private final NetworkProbe probe;
    private final NetworkInfo info;
    private final SingleObjectCache<NetworkStats> networkStatsCache;

    @Inject
    public NetworkService(Settings settings, NetworkProbe probe) {
        super(settings);
        this.probe = probe;
        TimeValue refreshInterval = settings.getAsTime("monitor.network.refresh_interval", TimeValue.timeValueSeconds(5L));
        this.logger.debug("Using probe [{}] with refresh_interval [{}]", probe, refreshInterval);
        this.info = probe.networkInfo();
        this.info.refreshInterval = refreshInterval.millis();
        this.networkStatsCache = new NetworkStatsCache(refreshInterval, probe.networkStats());
        if (this.logger.isDebugEnabled()) {
            StringBuilder netDebug = new StringBuilder("net_info");
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                String hostName = InetAddress.getLocalHost().getHostName();
                netDebug.append("\nhost [").append(hostName).append("]\n");
                while (interfaces.hasMoreElements()) {
                    NetworkInterface net = interfaces.nextElement();
                    netDebug.append(net.getName()).append('\t').append("display_name [").append(net.getDisplayName()).append("]\n");
                    Enumeration<InetAddress> addresses = net.getInetAddresses();
                    netDebug.append("\t\taddress ");
                    while (addresses.hasMoreElements()) {
                        netDebug.append("[").append(addresses.nextElement()).append("] ");
                    }
                    netDebug.append('\n');
                    netDebug.append("\t\tmtu [").append(net.getMTU()).append("] multicast [").append(net.supportsMulticast()).append("] ptp [").append(net.isPointToPoint()).append("] loopback [").append(net.isLoopback()).append("] up [").append(net.isUp()).append("] virtual [").append(net.isVirtual()).append("]").append('\n');
                    Enumeration<NetworkInterface> subInterfaces = net.getSubInterfaces();
                    if (subInterfaces == null || !subInterfaces.hasMoreElements()) continue;
                    netDebug.append("\t\t\tsub interfaces:\n");
                    while (subInterfaces.hasMoreElements()) {
                        net = subInterfaces.nextElement();
                        netDebug.append("\t\t\t").append(net.getName()).append("\t").append("display_name [").append(net.getDisplayName()).append("]\n");
                        addresses = net.getInetAddresses();
                        netDebug.append("\t\t\t\t\taddress ");
                        while (addresses.hasMoreElements()) {
                            netDebug.append("[").append(addresses.nextElement()).append("] ");
                        }
                        netDebug.append('\n');
                        netDebug.append("\t\t\t\t\tmtu [").append(net.getMTU()).append("] multicast [").append(net.supportsMulticast()).append("] ptp [").append(net.isPointToPoint()).append("] loopback [").append(net.isLoopback()).append("] up [").append(net.isUp()).append("] virtual [").append(net.isVirtual()).append("]").append('\n');
                    }
                }
            }
            catch (Exception ex) {
                netDebug.append("failed to get Network Interface Info [" + ex.getMessage() + "]");
            }
            this.logger.debug(netDebug.toString(), new Object[0]);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("ifconfig\n\n" + this.ifconfig(), new Object[0]);
        }
        this.stats();
    }

    public NetworkInfo info() {
        return this.info;
    }

    public NetworkStats stats() {
        return this.networkStatsCache.getOrRefresh();
    }

    public String ifconfig() {
        return this.probe.ifconfig();
    }

    private class NetworkStatsCache
    extends SingleObjectCache<NetworkStats> {
        public NetworkStatsCache(TimeValue interval, NetworkStats initValue) {
            super(interval, initValue);
        }

        @Override
        protected NetworkStats refresh() {
            return NetworkService.this.probe.networkStats();
        }
    }
}

