/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.children;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.lucene.ReaderContextAware;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.ApplyAcceptedDocsFilter;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.LongObjectPagedHashMap;
import org.elasticsearch.index.search.child.ConstantScorer;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.children.InternalChildren;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class ParentToChildrenAggregator
extends SingleBucketAggregator
implements ReaderContextAware {
    private final String parentType;
    private final Filter childFilter;
    private final Filter parentFilter;
    private final ValuesSource.Bytes.ParentChild valuesSource;
    private final LongArray parentOrdToBuckets;
    private final LongObjectPagedHashMap<long[]> parentOrdToOtherBuckets;
    private boolean multipleBucketsPerParentOrd = false;
    private Set<AtomicReaderContext> replay = new LinkedHashSet<AtomicReaderContext>();
    private SortedDocValues globalOrdinals;
    private Bits parentDocs;

    public ParentToChildrenAggregator(String name, AggregatorFactories factories, AggregationContext aggregationContext, Aggregator parent, String parentType, Filter childFilter, Filter parentFilter, ValuesSource.Bytes.ParentChild valuesSource, long maxOrd) {
        super(name, factories, aggregationContext, parent);
        this.parentType = parentType;
        this.childFilter = new ApplyAcceptedDocsFilter(aggregationContext.searchContext().filterCache().cache(childFilter));
        this.parentFilter = aggregationContext.searchContext().filterCache().cache(parentFilter);
        this.parentOrdToBuckets = aggregationContext.bigArrays().newLongArray(maxOrd, false);
        this.parentOrdToBuckets.fill(0L, maxOrd, -1L);
        this.parentOrdToOtherBuckets = new LongObjectPagedHashMap(aggregationContext.bigArrays());
        this.valuesSource = valuesSource;
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        return new InternalChildren(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalChildren(this.name, 0L, this.buildEmptySubAggregations());
    }

    @Override
    public void collect(int docId, long bucketOrdinal) throws IOException {
        long globalOrdinal;
        if (this.parentDocs.get(docId) && (globalOrdinal = (long)this.globalOrdinals.getOrd(docId)) != -1L) {
            if (this.parentOrdToBuckets.get(globalOrdinal) == -1L) {
                this.parentOrdToBuckets.set(globalOrdinal, bucketOrdinal);
            } else {
                long[] bucketOrds = this.parentOrdToOtherBuckets.get(globalOrdinal);
                if (bucketOrds != null) {
                    bucketOrds = Arrays.copyOf(bucketOrds, bucketOrds.length + 1);
                    bucketOrds[bucketOrds.length - 1] = bucketOrdinal;
                    this.parentOrdToOtherBuckets.put(globalOrdinal, bucketOrds);
                } else {
                    this.parentOrdToOtherBuckets.put(globalOrdinal, new long[]{bucketOrdinal});
                }
                this.multipleBucketsPerParentOrd = true;
            }
        }
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        if (this.replay == null) {
            return;
        }
        this.globalOrdinals = this.valuesSource.globalOrdinalsValues(this.parentType);
        assert (this.globalOrdinals != null);
        try {
            DocIdSet parentDocIdSet = this.parentFilter.getDocIdSet(reader, null);
            this.parentDocs = DocIdSets.toSafeBits(reader.reader(), parentDocIdSet);
            DocIdSet childDocIdSet = this.childFilter.getDocIdSet(reader, null);
            if (this.globalOrdinals != null && !DocIdSets.isEmpty(childDocIdSet)) {
                this.replay.add(reader);
            }
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
    }

    @Override
    protected void doPostCollection() throws IOException {
        Set<AtomicReaderContext> replay = this.replay;
        this.replay = null;
        for (AtomicReaderContext atomicReaderContext : replay) {
            DocIdSetIterator childDocsIter;
            this.context.setNextReader(atomicReaderContext);
            SortedDocValues globalOrdinals = this.valuesSource.globalOrdinalsValues(this.parentType);
            DocIdSet childDocIdSet = this.childFilter.getDocIdSet(atomicReaderContext, atomicReaderContext.reader().getLiveDocs());
            if (childDocIdSet == null || (childDocsIter = childDocIdSet.iterator()) == null) continue;
            this.context.setScorer(ConstantScorer.create(childDocsIter, null, 1.0f));
            int docId = childDocsIter.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                long bucketOrd;
                long globalOrdinal = globalOrdinals.getOrd(docId);
                if (globalOrdinal != -1L && (bucketOrd = this.parentOrdToBuckets.get(globalOrdinal)) != -1L) {
                    long[] otherBucketOrds;
                    this.collectBucket(docId, bucketOrd);
                    if (this.multipleBucketsPerParentOrd && (otherBucketOrds = this.parentOrdToOtherBuckets.get(globalOrdinal)) != null) {
                        for (long otherBucketOrd : otherBucketOrds) {
                            this.collectBucket(docId, otherBucketOrd);
                        }
                    }
                }
                docId = childDocsIter.nextDoc();
            }
        }
    }

    @Override
    protected void doClose() {
        Releasables.close(this.parentOrdToBuckets, this.parentOrdToOtherBuckets);
    }

    public static class Factory
    extends ValuesSourceAggregatorFactory<ValuesSource.Bytes.ParentChild> {
        private final String parentType;
        private final Filter parentFilter;
        private final Filter childFilter;

        public Factory(String name, ValuesSourceConfig<ValuesSource.Bytes.ParentChild> config, String parentType, Filter parentFilter, Filter childFilter) {
            super(name, InternalChildren.TYPE.name(), config);
            this.parentType = parentType;
            this.parentFilter = parentFilter;
            this.childFilter = childFilter;
        }

        @Override
        protected Aggregator createUnmapped(AggregationContext aggregationContext, Aggregator parent) {
            return new NonCollectingAggregator(this.name, aggregationContext, parent){

                @Override
                public InternalAggregation buildEmptyAggregation() {
                    return new InternalChildren(this.name, 0L, this.buildEmptySubAggregations());
                }
            };
        }

        @Override
        protected Aggregator create(ValuesSource.Bytes.ParentChild valuesSource, long expectedBucketsCount, AggregationContext aggregationContext, Aggregator parent) {
            long maxOrd = valuesSource.globalMaxOrd(aggregationContext.searchContext().searcher(), this.parentType);
            return new ParentToChildrenAggregator(this.name, this.factories, aggregationContext, parent, this.parentType, this.childFilter, this.parentFilter, valuesSource, maxOrd);
        }
    }
}

