/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.joda.time.DateTime;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class InternalDateHistogram
extends InternalHistogram<Bucket>
implements DateHistogram {
    static final InternalAggregation.Type TYPE = new InternalAggregation.Type("date_histogram", "dhisto");
    static final Factory FACTORY = new Factory();
    private static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalDateHistogram readResult(StreamInput in) throws IOException {
            InternalDateHistogram histogram = new InternalDateHistogram();
            histogram.readFrom(in);
            return histogram;
        }
    };
    private ObjectObjectOpenHashMap<String, Bucket> bucketsMap;

    public static void registerStream() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalDateHistogram() {
    }

    InternalDateHistogram(String name, List<Bucket> buckets, InternalOrder order, long minDocCount, InternalHistogram.EmptyBucketInfo emptyBucketInfo, @Nullable ValueFormatter formatter, boolean keyed) {
        super(name, buckets, order, minDocCount, emptyBucketInfo, formatter, keyed);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    protected InternalHistogram.Factory<Bucket> getFactory() {
        return FACTORY;
    }

    @Override
    public Bucket getBucketByKey(String key) {
        try {
            long time = Long.parseLong(key);
            return (Bucket)super.getBucketByKey(time);
        }
        catch (NumberFormatException nfe) {
            if (this.bucketsMap == null) {
                this.bucketsMap = new ObjectObjectOpenHashMap();
                for (Bucket bucket : this.buckets) {
                    this.bucketsMap.put(bucket.getKey(), bucket);
                }
            }
            return this.bucketsMap.get(key);
        }
    }

    @Override
    public DateHistogram.Bucket getBucketByKey(DateTime key) {
        return (DateHistogram.Bucket)this.getBucketByKey(key.getMillis());
    }

    @Override
    protected Bucket createBucket(long key, long docCount, InternalAggregations aggregations, ValueFormatter formatter) {
        return new Bucket(key, docCount, aggregations, formatter);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.bucketsMap = null;
    }

    static class Factory
    extends InternalHistogram.Factory<Bucket> {
        private Factory() {
        }

        @Override
        public String type() {
            return TYPE.name();
        }

        public InternalDateHistogram create(String name, List<Bucket> buckets, InternalOrder order, long minDocCount, InternalHistogram.EmptyBucketInfo emptyBucketInfo, @Nullable ValueFormatter formatter, boolean keyed) {
            return new InternalDateHistogram(name, buckets, order, minDocCount, emptyBucketInfo, formatter, keyed);
        }

        @Override
        public Bucket createBucket(long key, long docCount, InternalAggregations aggregations, @Nullable ValueFormatter formatter) {
            return new Bucket(key, docCount, aggregations, formatter);
        }
    }

    static class Bucket
    extends InternalHistogram.Bucket
    implements DateHistogram.Bucket {
        Bucket(long key, long docCount, InternalAggregations aggregations, @Nullable ValueFormatter formatter) {
            super(key, docCount, formatter, aggregations);
        }

        protected InternalHistogram.Factory<Bucket> getFactory() {
            return FACTORY;
        }

        @Override
        public String getKey() {
            return this.formatter != null ? this.formatter.format(this.key) : ValueFormatter.DateTime.DEFAULT.format(this.key);
        }

        @Override
        public DateTime getKeyAsDate() {
            return new DateTime(this.key, DateTimeZone.UTC);
        }

        public String toString() {
            return this.getKey();
        }
    }
}

