/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.scripted;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalMetricsAggregation;
import org.elasticsearch.search.aggregations.metrics.scripted.ScriptedMetric;

public class InternalScriptedMetric
extends InternalMetricsAggregation
implements ScriptedMetric {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("scripted_metric");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalScriptedMetric readResult(StreamInput in) throws IOException {
            InternalScriptedMetric result = new InternalScriptedMetric();
            result.readFrom(in);
            return result;
        }
    };
    private String scriptLang;
    private ScriptService.ScriptType scriptType;
    private String reduceScript;
    private Map<String, Object> reduceParams;
    private Object aggregation;

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    private InternalScriptedMetric() {
    }

    private InternalScriptedMetric(String name) {
        super(name);
    }

    public InternalScriptedMetric(String name, Object aggregation, String scriptLang, ScriptService.ScriptType scriptType, String reduceScript, Map<String, Object> reduceParams) {
        this(name);
        this.aggregation = aggregation;
        this.scriptType = scriptType;
        this.reduceScript = reduceScript;
        this.reduceParams = reduceParams;
        this.scriptLang = scriptLang;
    }

    @Override
    public Object aggregation() {
        return this.aggregation;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InternalAggregation reduce(InternalAggregation.ReduceContext reduceContext) {
        void var4_7;
        ArrayList<Object> aggregationObjects = new ArrayList<Object>();
        for (InternalAggregation internalAggregation : reduceContext.aggregations()) {
            InternalScriptedMetric mapReduceAggregation = (InternalScriptedMetric)internalAggregation;
            aggregationObjects.add(mapReduceAggregation.aggregation());
        }
        InternalScriptedMetric firstAggregation = (InternalScriptedMetric)reduceContext.aggregations().get(0);
        if (firstAggregation.reduceScript != null) {
            HashMap<String, Object> params = firstAggregation.reduceParams != null ? new HashMap<String, Object>(firstAggregation.reduceParams) : new HashMap<String, ArrayList<Object>>();
            params.put("_aggs", aggregationObjects);
            ExecutableScript script = reduceContext.scriptService().executable(firstAggregation.scriptLang, firstAggregation.reduceScript, firstAggregation.scriptType, ScriptContext.Standard.AGGS, params);
            Object object = script.run();
        } else {
            ArrayList<Object> arrayList = aggregationObjects;
        }
        return new InternalScriptedMetric(firstAggregation.getName(), var4_7, firstAggregation.scriptLang, firstAggregation.scriptType, firstAggregation.reduceScript, firstAggregation.reduceParams);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.name = in.readString();
        this.scriptLang = in.readOptionalString();
        this.scriptType = ScriptService.ScriptType.readFrom(in);
        this.reduceScript = in.readOptionalString();
        this.reduceParams = in.readMap();
        this.aggregation = in.readGenericValue();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.scriptLang);
        ScriptService.ScriptType.writeTo(this.scriptType, out);
        out.writeOptionalString(this.reduceScript);
        out.writeMap(this.reduceParams);
        out.writeGenericValue(this.aggregation);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.field("value", this.aggregation);
    }
}

