/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.term;

import java.io.IOException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.search.suggest.DirectSpellcheckerSettings;
import org.elasticsearch.search.suggest.SuggestContextParser;
import org.elasticsearch.search.suggest.SuggestUtils;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.search.suggest.term.TermSuggester;
import org.elasticsearch.search.suggest.term.TermSuggestionContext;

public final class TermSuggestParser
implements SuggestContextParser {
    private TermSuggester suggester;

    public TermSuggestParser(TermSuggester suggester) {
        this.suggester = suggester;
    }

    @Override
    public SuggestionSearchContext.SuggestionContext parse(XContentParser parser, MapperService mapperService, IndexQueryParserService queryParserService) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        TermSuggestionContext suggestion = new TermSuggestionContext((Suggester<? extends TermSuggestionContext>)this.suggester);
        DirectSpellcheckerSettings settings = suggestion.getDirectSpellCheckerSettings();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                fieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                this.parseTokenValue(parser, mapperService, fieldName, suggestion, settings);
                continue;
            }
            throw new ElasticsearchIllegalArgumentException("suggester[term]  doesn't support field [" + fieldName + "]");
        }
        return suggestion;
    }

    private void parseTokenValue(XContentParser parser, MapperService mapperService, String fieldName, TermSuggestionContext suggestion, DirectSpellcheckerSettings settings) throws IOException {
        if (!SuggestUtils.parseSuggestContext(parser, mapperService, fieldName, suggestion) && !SuggestUtils.parseDirectSpellcheckerSettings(parser, fieldName, settings)) {
            throw new ElasticsearchIllegalArgumentException("suggester[term] doesn't support [" + fieldName + "]");
        }
    }
}

