/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups;

import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.jgroups.CamelJGroupsReceiver;
import org.apache.camel.component.jgroups.JGroupsEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.jgroups.Channel;
import org.jgroups.Receiver;

public class JGroupsConsumer
extends DefaultConsumer {
    private final Channel channel;
    private final String clusterName;
    private final CamelJGroupsReceiver receiver;
    private final JGroupsEndpoint endpoint;

    public JGroupsConsumer(JGroupsEndpoint endpoint, Processor processor, Channel channel, String clusterName) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.channel = channel;
        this.clusterName = clusterName;
        this.receiver = new CamelJGroupsReceiver(endpoint, processor);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.log.debug("Connecting receiver: {} to the cluster: {}.", (Object)this.receiver, (Object)this.clusterName);
        this.channel.setReceiver((Receiver)this.receiver);
        this.endpoint.connect();
    }

    protected void doStop() throws Exception {
        this.log.debug("Closing connection to cluster: {} from receiver: {}.", (Object)this.clusterName, (Object)this.receiver);
        this.channel.setReceiver(null);
        this.endpoint.disconnect();
        super.doStop();
    }
}

