/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.sf.flatpack.AbstractDelimiterParser;
import net.sf.flatpack.InitialisationException;
import net.sf.flatpack.xml.MapParser;
import org.jdom.JDOMException;

public class DelimiterParser
extends AbstractDelimiterParser {
    private InputStream pzmapXMLStream = null;
    private File pzmapXML = null;
    private Reader pzmapReader;
    private InputStream dataSourceStream = null;
    private File dataSource = null;

    public DelimiterParser(File pzmapXML, File dataSource, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(null, delimiter, qualifier, ignoreFirstRecord);
        this.pzmapXML = pzmapXML;
        this.dataSource = dataSource;
    }

    public DelimiterParser(InputStream pzmapXMLStream, InputStream dataSourceStream, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(null, delimiter, qualifier, ignoreFirstRecord);
        this.pzmapXMLStream = pzmapXMLStream;
        this.dataSourceStream = dataSourceStream;
    }

    public DelimiterParser(File dataSource, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(null, delimiter, qualifier, ignoreFirstRecord);
        this.dataSource = dataSource;
    }

    public DelimiterParser(InputStream dataSourceStream, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(null, delimiter, qualifier, ignoreFirstRecord);
        this.dataSourceStream = dataSourceStream;
    }

    public DelimiterParser(Reader dataSourceReader, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSourceReader, delimiter, qualifier, ignoreFirstRecord);
    }

    public DelimiterParser(Reader dataSourceReader, Reader pzmapReader, char delimiter, char qualifier, boolean ignoreFirstRecord) {
        super(dataSourceReader, delimiter, qualifier, ignoreFirstRecord);
        this.pzmapReader = pzmapReader;
    }

    protected void init() {
        try {
            InputStreamReader r;
            if (this.dataSourceStream != null) {
                r = new InputStreamReader(this.dataSourceStream);
                this.setDataSourceReader(r);
                this.addToCloseReaderList(r);
            } else if (this.dataSource != null) {
                r = new FileReader(this.dataSource);
                this.setDataSourceReader(r);
                this.addToCloseReaderList(r);
            }
            boolean closeMapReader = false;
            if (this.pzmapXML != null) {
                this.pzmapReader = new FileReader(this.pzmapXML);
                closeMapReader = true;
            } else if (this.pzmapXMLStream != null) {
                this.pzmapReader = new InputStreamReader(this.pzmapXMLStream);
                closeMapReader = true;
            }
            if (this.pzmapReader != null) {
                try {
                    this.setPzMetaData(MapParser.parseMap(this.pzmapReader, this));
                }
                finally {
                    if (closeMapReader) {
                        this.pzmapReader.close();
                    }
                }
            }
            this.setInitialised(true);
        }
        catch (JDOMException e) {
            throw new InitialisationException(e);
        }
        catch (IOException e) {
            throw new InitialisationException(e);
        }
    }

    protected boolean shouldCreateMDFromFile() {
        return this.pzmapReader == null;
    }
}

