/*
 * Decompiled with CFR 0.152.
 */
package net.sf.flatpack.writer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.flatpack.writer.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWriter
implements Writer {
    private final BufferedWriter writer;
    private Map<String, Object> rowMap;

    public AbstractWriter(java.io.Writer output) {
        this.writer = new BufferedWriter(output);
    }

    @Override
    public void addRecordEntry(String columnName, Object value) {
        if (this.rowMap == null) {
            this.rowMap = new HashMap<String, Object>();
        }
        if (!this.validateColumnTitle(columnName)) {
            throw new IllegalArgumentException("unknown column: \"" + columnName + "\"");
        }
        this.rowMap.put(columnName, value);
    }

    protected abstract boolean validateColumnTitle(String var1);

    @Override
    public void nextRecord() throws IOException {
        this.rowMap = null;
        this.writer.newLine();
    }

    protected void write(Object val) throws IOException {
        Object value = val;
        if (value == null) {
            value = "";
        }
        this.writer.write(value.toString());
    }

    protected void write(char character) throws IOException {
        this.writer.write(character);
    }

    protected void write(char[] characters) throws IOException {
        this.writer.write(characters);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    protected Map<String, Object> getRowMap() {
        return this.rowMap;
    }
}

