/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extras.patch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.wildfly.extras.patch.PatchId;
import org.wildfly.extras.patch.PatchMetadata;

public final class PatchMetadataBuilder {
    private PatchId patchId;
    private PatchId oneoffId;
    private Set<String> roles = new LinkedHashSet<String>();
    private Set<PatchId> dependencies = new LinkedHashSet<PatchId>();
    private List<String> postCommands = new ArrayList<String>();

    public PatchMetadataBuilder patchId(PatchId patchId) {
        this.patchId = patchId;
        return this;
    }

    public PatchMetadataBuilder roles(String ... roles) {
        if (roles != null) {
            this.roles.addAll(Arrays.asList(roles));
        }
        return this;
    }

    public PatchMetadataBuilder roles(Set<String> roles) {
        if (roles != null) {
            this.roles.addAll(roles);
        }
        return this;
    }

    public PatchMetadataBuilder oneoffId(PatchId oneoffId) {
        this.oneoffId = oneoffId;
        return this;
    }

    public PatchMetadataBuilder dependencies(PatchId ... patchIds) {
        if (patchIds != null) {
            this.dependencies.addAll(Arrays.asList(patchIds));
        }
        return this;
    }

    public PatchMetadataBuilder dependencies(Set<PatchId> patchIds) {
        if (patchIds != null) {
            this.dependencies.addAll(patchIds);
        }
        return this;
    }

    public PatchMetadataBuilder postCommands(String ... commands) {
        if (commands != null) {
            this.postCommands.addAll(Arrays.asList(commands));
        }
        return this;
    }

    public PatchMetadataBuilder postCommands(List<String> commands) {
        if (commands != null) {
            this.postCommands.addAll(commands);
        }
        return this;
    }

    public PatchMetadata build() {
        return new PatchMetadata(this.patchId, this.roles, this.oneoffId, this.dependencies, this.postCommands);
    }
}

