/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.PollingConsumer;
import org.apache.camel.impl.ConsumerCache;
import org.apache.camel.impl.EmptyConsumerCache;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollEnricher
extends ServiceSupport
implements AsyncProcessor,
IdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(PollEnricher.class);
    private CamelContext camelContext;
    private ConsumerCache consumerCache;
    private String id;
    private AggregationStrategy aggregationStrategy;
    private final Expression expression;
    private long timeout;
    private boolean aggregateOnException;
    private int cacheSize;
    private boolean ignoreInvalidEndpoint;

    public PollEnricher(Expression expression, long timeout) {
        this.expression = expression;
        this.timeout = timeout;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.consumerCache.getEndpointUtilizationStatistics();
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isAggregateOnException() {
        return this.aggregateOnException;
    }

    public void setAggregateOnException(boolean aggregateOnException) {
        this.aggregateOnException = aggregateOnException;
    }

    public void setDefaultAggregationStrategy() {
        this.aggregationStrategy = PollEnricher.defaultAggregationStrategy();
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        Exchange resourceExchange;
        PollingConsumer consumer;
        Endpoint endpoint;
        try {
            this.preCheckPoll(exchange);
        }
        catch (Exception e) {
            exchange.setException(new CamelExchangeException("Error during pre poll check", exchange, e));
            callback.done(true);
            return true;
        }
        Object recipient = null;
        try {
            recipient = this.expression.evaluate(exchange, Object.class);
            endpoint = this.resolveEndpoint(exchange, recipient);
            consumer = this.consumerCache.acquirePollingConsumer(endpoint);
        }
        catch (Throwable e) {
            if (this.isIgnoreInvalidEndpoint()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Endpoint uri is invalid: " + recipient + ". This exception will be ignored.", e);
                }
            } else {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
        try {
            if (this.timeout < 0L) {
                LOG.debug("Consumer receive: {}", (Object)consumer);
                resourceExchange = consumer.receive();
            } else if (this.timeout == 0L) {
                LOG.debug("Consumer receiveNoWait: {}", (Object)consumer);
                resourceExchange = consumer.receiveNoWait();
            } else {
                LOG.debug("Consumer receive with timeout: {} ms. {}", (Object)this.timeout, (Object)consumer);
                resourceExchange = consumer.receive(this.timeout);
            }
            if (resourceExchange == null) {
                LOG.debug("Consumer received no exchange");
            } else {
                LOG.debug("Consumer received: {}", (Object)resourceExchange);
            }
        }
        catch (Exception e) {
            exchange.setException(new CamelExchangeException("Error during poll", exchange, e));
            callback.done(true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.consumerCache.releasePollingConsumer(endpoint, consumer);
        }
        try {
            if (!this.isAggregateOnException() && resourceExchange != null && resourceExchange.isFailed()) {
                ExchangeHelper.copyResultsPreservePattern(exchange, resourceExchange);
            } else {
                PollEnricher.prepareResult(exchange);
                ExchangeHelper.prepareAggregation(exchange, resourceExchange);
                Exchange aggregatedExchange = this.aggregationStrategy.aggregate(exchange, resourceExchange);
                if (aggregatedExchange != null) {
                    ExchangeHelper.copyResultsPreservePattern(exchange, aggregatedExchange);
                    if (resourceExchange != null) {
                        resourceExchange.handoverCompletions(exchange);
                    }
                }
            }
            if (exchange.hasOut()) {
                exchange.getOut().setHeader("CamelToEndpoint", consumer.getEndpoint().getEndpointUri());
            } else {
                exchange.getIn().setHeader("CamelToEndpoint", consumer.getEndpoint().getEndpointUri());
            }
        }
        catch (Throwable e) {
            exchange.setException(new CamelExchangeException("Error occurred during aggregation", exchange, e));
            callback.done(true);
            return true;
        }
        callback.done(true);
        return true;
    }

    protected Endpoint resolveEndpoint(Exchange exchange, Object recipient) {
        if (recipient instanceof String) {
            recipient = ((String)recipient).trim();
        }
        return ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    protected void preCheckPoll(Exchange exchange) throws Exception {
    }

    private static void prepareResult(Exchange exchange) {
        if (exchange.getPattern().isOutCapable()) {
            exchange.getOut().copyFrom(exchange.getIn());
        }
    }

    private static AggregationStrategy defaultAggregationStrategy() {
        return new CopyAggregationStrategy();
    }

    public String toString() {
        return "PollEnrich[" + this.expression + "]";
    }

    @Override
    protected void doStart() throws Exception {
        if (this.consumerCache == null) {
            if (this.cacheSize < 0) {
                this.consumerCache = new EmptyConsumerCache(this, this.camelContext);
                LOG.debug("PollEnrich {} is not using ConsumerCache", (Object)this);
            } else if (this.cacheSize == 0) {
                this.consumerCache = new ConsumerCache(this, this.camelContext);
                LOG.debug("PollEnrich {} using ConsumerCache with default cache size", (Object)this);
            } else {
                this.consumerCache = new ConsumerCache((Object)this, this.camelContext, this.cacheSize);
                LOG.debug("PollEnrich {} using ConsumerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
            }
        }
        ServiceHelper.startServices(this.consumerCache, this.aggregationStrategy);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.aggregationStrategy, this.consumerCache);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownServices(this.aggregationStrategy, this.consumerCache);
    }

    private static class CopyAggregationStrategy
    implements AggregationStrategy {
        private CopyAggregationStrategy() {
        }

        @Override
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (newExchange != null) {
                ExchangeHelper.copyResultsPreservePattern(oldExchange, newExchange);
            } else {
                oldExchange.getIn().setBody(null);
                oldExchange.setOut(null);
            }
            return oldExchange;
        }
    }
}

