/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.elasticsearch.ElasticsearchConfiguration;
import org.apache.camel.component.elasticsearch.ElasticsearchConstants;
import org.apache.camel.component.elasticsearch.ElasticsearchEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.elasticsearch.common.transport.InetSocketTransportAddress;

public class ElasticsearchComponent
extends UriEndpointComponent {
    public ElasticsearchComponent() {
        super(ElasticsearchEndpoint.class);
    }

    public ElasticsearchComponent(CamelContext context) {
        super(context, ElasticsearchEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        ElasticsearchConfiguration config = new ElasticsearchConfiguration();
        this.setProperties(config, parameters);
        if ("local".equals(remaining)) {
            config.setLocal(true);
            config.setClusterName(null);
        } else {
            config.setLocal(false);
            config.setClusterName(remaining);
        }
        if (config.getData() == null) {
            config.setData(config.isLocal());
        }
        if (config.isLocal() && !config.getData().booleanValue()) {
            throw new IllegalArgumentException("invalid to use local node without data");
        }
        config.setTransportAddressesList(this.parseTransportAddresses(config.getTransportAddresses(), config));
        ElasticsearchEndpoint endpoint = new ElasticsearchEndpoint(uri, this, config);
        return endpoint;
    }

    private List<InetSocketTransportAddress> parseTransportAddresses(String ipsString, ElasticsearchConfiguration config) {
        if (ipsString == null || ipsString.isEmpty()) {
            return null;
        }
        List<String> addressesStr = Arrays.asList(ipsString.split(","));
        ArrayList<InetSocketTransportAddress> addressesTrAd = new ArrayList<InetSocketTransportAddress>(addressesStr.size());
        for (String address : addressesStr) {
            String[] split = address.split(":");
            if (split.length <= 0) {
                throw new IllegalArgumentException();
            }
            String hostname = split[0];
            Integer port = split.length > 1 ? Integer.parseInt(split[1]) : ElasticsearchConstants.DEFAULT_PORT;
            addressesTrAd.add(new InetSocketTransportAddress(hostname, port.intValue()));
        }
        return addressesTrAd;
    }
}

