/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.Arrays;
import java.util.Properties;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.KafkaStream;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import scala.Function1;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.RichInt$;

public final class TestEndToEndLatency$ {
    public static final TestEndToEndLatency$ MODULE$;

    static {
        new TestEndToEndLatency$();
    }

    public void main(String[] args) {
        if (args.length != 6) {
            System.err.println(new StringBuilder().append((Object)"USAGE: java ").append((Object)this.getClass().getName()).append((Object)" broker_list zookeeper_connect topic num_messages consumer_fetch_max_wait producer_acks").toString());
            System.exit(1);
        }
        String brokerList = args[0];
        String zkConnect = args[1];
        String topic = args[2];
        int numMessages = new StringOps(Predef$.MODULE$.augmentString(args[3])).toInt();
        int consumerFetchMaxWait = new StringOps(Predef$.MODULE$.augmentString(args[4])).toInt();
        int producerAcks = new StringOps(Predef$.MODULE$.augmentString(args[5])).toInt();
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", topic);
        consumerProps.put("auto.commit.enable", "false");
        consumerProps.put("auto.offset.reset", "largest");
        consumerProps.put("zookeeper.connect", zkConnect);
        consumerProps.put("fetch.wait.max.ms", ((Object)BoxesRunTime.boxToInteger((int)consumerFetchMaxWait)).toString());
        consumerProps.put("socket.timeout.ms", ((Object)BoxesRunTime.boxToInteger((int)1201000)).toString());
        ConsumerConfig config = new ConsumerConfig(consumerProps);
        ConsumerConnector connector = Consumer$.MODULE$.create(config);
        KafkaStream stream = (KafkaStream)((IterableLike)Option$.MODULE$.option2Iterable(connector.createMessageStreams((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)BoxesRunTime.boxToInteger((int)1))})))).get((Object)topic)).head()).head();
        Iterator iter = stream.iterator();
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("linger.ms", "0");
        producerProps.put("block.on.buffer.full", "true");
        producerProps.put("acks", ((Object)BoxesRunTime.boxToInteger((int)producerAcks)).toString());
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        KafkaProducer producer = new KafkaProducer(producerProps);
        Thread.sleep(5000L);
        byte[] message = "hello there beautiful".getBytes();
        DoubleRef totalTime = DoubleRef.create((double)0.0);
        long[] latencies = new long[numMessages];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(topic, (ConsumerIterator)iter, producer, message, totalTime, latencies){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final ConsumerIterator iter$1;
            private final KafkaProducer producer$1;
            private final byte[] message$1;
            private final DoubleRef totalTime$1;
            private final long[] latencies$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                long begin = System.nanoTime();
                this.producer$1.send(new ProducerRecord(this.topic$1, (Object)this.message$1));
                Object received = this.iter$1.next();
                long elapsed = System.nanoTime() - begin;
                if (i % 1000 == 0) {
                    Predef$.MODULE$.println((Object)new StringBuilder().append(i).append((Object)"\t").append((Object)BoxesRunTime.boxToDouble((double)((double)elapsed / 1000.0 / 1000.0))).toString());
                }
                this.totalTime$1.elem += (double)elapsed;
                this.latencies$1[i] = elapsed / 1000L / 1000L;
            }
            {
                this.topic$1 = topic$1;
                this.iter$1 = iter$1;
                this.producer$1 = producer$1;
                this.message$1 = message$1;
                this.totalTime$1 = totalTime$1;
                this.latencies$1 = latencies$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Avg latency: %.4f ms\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(totalTime.elem / (double)numMessages / 1000.0 / 1000.0))})));
        Arrays.sort(latencies);
        long p50 = latencies[(int)((double)latencies.length * 0.5)];
        long p99 = latencies[(int)((double)latencies.length * 0.99)];
        long p999 = latencies[(int)((double)latencies.length * 0.999)];
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Percentiles: 50th = %d, 99th = %d, 99.9th = %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)p50), BoxesRunTime.boxToLong((long)p99), BoxesRunTime.boxToLong((long)p999)})));
        producer.close();
        connector.commitOffsets(true);
        connector.shutdown();
        System.exit(0);
    }

    private TestEndToEndLatency$() {
        MODULE$ = this;
    }
}

