/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.camel.cdi.CdiBeanManagerHelper;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiBeanRegistry
implements Registry {
    private static final Logger LOG = LoggerFactory.getLogger(CdiBeanRegistry.class);
    private final BeanManager beanManager;

    public CdiBeanRegistry(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public Object lookupByName(String name) {
        ObjectHelper.notEmpty((String)name, (String)"name");
        LOG.trace("Looking up bean with name {}", (Object)name);
        return CdiBeanManagerHelper.lookupBeanByName(this.beanManager, name);
    }

    public <T> T lookupByNameAndType(String name, Class<T> type) {
        ObjectHelper.notEmpty((String)name, (String)"name");
        ObjectHelper.notNull(type, (String)"type");
        LOG.trace("Looking up bean with name {} of type {}", (Object)name, type);
        return CdiBeanManagerHelper.lookupBeanByNameAndType(this.beanManager, name, type);
    }

    public <T> Map<String, T> findByTypeWithName(Class<T> type) {
        ObjectHelper.notNull(type, (String)"type");
        LOG.trace("Lookups based of type {}", type);
        HashMap<String, T> beans = new HashMap<String, T>();
        Set definitions = this.beanManager.getBeans(type, new Annotation[0]);
        if (definitions == null) {
            return beans;
        }
        for (Bean bean : definitions) {
            if (bean.getName() == null) continue;
            T obj = CdiBeanManagerHelper.lookupBeanByNameAndType(this.beanManager, bean.getName(), type);
            beans.put(bean.getName(), obj);
        }
        return beans;
    }

    public <T> Set<T> findByType(Class<T> type) {
        ObjectHelper.notNull(type, (String)"type");
        LOG.trace("Lookups based of type {}", type);
        HashSet<T> beans = new HashSet<T>();
        Set definitions = this.beanManager.getBeans(type, new Annotation[0]);
        if (definitions == null) {
            return beans;
        }
        for (Bean bean : definitions) {
            if (bean.getName() == null) continue;
            T obj = CdiBeanManagerHelper.lookupBeanByNameAndType(this.beanManager, bean.getName(), type);
            beans.add(obj);
        }
        return beans;
    }

    public Object lookup(String name) {
        return this.lookupByName(name);
    }

    public <T> T lookup(String name, Class<T> type) {
        return this.lookupByNameAndType(name, type);
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return this.findByTypeWithName(type);
    }

    public String toString() {
        return "CdiRegistry[" + System.identityHashCode(this) + "]";
    }
}

