/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Consume;
import org.apache.camel.EndpointInject;
import org.apache.camel.Produce;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.cdi.internal.CamelExtension;
import org.apache.camel.impl.DefaultCamelBeanPostProcessor;

public class BeanAdapter {
    private final List<Method> consumeMethods = new ArrayList<Method>();
    private final List<Method> produceMethods = new ArrayList<Method>();
    private final List<Method> endpointMethods = new ArrayList<Method>();
    private final List<Field> produceFields = new ArrayList<Field>();
    private final List<Field> endpointFields = new ArrayList<Field>();
    private final ContextName startup;

    public BeanAdapter(ContextName startup) {
        this.startup = startup;
    }

    public boolean isEmpty() {
        return this.consumeMethods.isEmpty() && this.produceMethods.isEmpty() && this.produceFields.isEmpty() && this.endpointMethods.isEmpty() && this.endpointFields.isEmpty();
    }

    public void addConsumeMethod(Method method) {
        this.consumeMethods.add(method);
    }

    public void addProduceMethod(Method method) {
        this.produceMethods.add(method);
    }

    public void addProduceField(Field field) {
        this.produceFields.add(field);
    }

    public void addEndpointField(Field field) {
        this.endpointFields.add(field);
    }

    public void addEndpointMethod(Method method) {
        this.endpointMethods.add(method);
    }

    public void inject(CamelExtension camelExtension, Object reference, String beanName) {
        String contextName;
        DefaultCamelBeanPostProcessor postProcessor;
        Consume annotation;
        for (Method method : this.consumeMethods) {
            annotation = method.getAnnotation(Consume.class);
            if (annotation == null || (postProcessor = camelExtension.getPostProcessor(contextName = CamelExtension.getCamelContextName(annotation.context(), this.startup), null)) == null) continue;
            postProcessor.getPostProcessorHelper().consumerInjection(method, reference, beanName);
        }
        for (Method method : this.produceMethods) {
            annotation = method.getAnnotation(Produce.class);
            if (annotation == null || (postProcessor = camelExtension.getPostProcessor(contextName = CamelExtension.getCamelContextName(annotation.context(), this.startup), null)) == null || !postProcessor.getPostProcessorHelper().matchContext(contextName)) continue;
            postProcessor.setterInjection(method, reference, beanName, annotation.uri(), annotation.ref(), annotation.property());
        }
        for (Method method : this.endpointMethods) {
            annotation = method.getAnnotation(EndpointInject.class);
            if (annotation == null || (postProcessor = camelExtension.getPostProcessor(contextName = CamelExtension.getCamelContextName(annotation.context(), this.startup), null)) == null || !postProcessor.getPostProcessorHelper().matchContext(contextName)) continue;
            postProcessor.setterInjection(method, reference, beanName, annotation.uri(), annotation.ref(), annotation.property());
        }
        for (Field field : this.produceFields) {
            annotation = field.getAnnotation(Produce.class);
            if (annotation == null || (postProcessor = camelExtension.getPostProcessor(contextName = CamelExtension.getCamelContextName(annotation.context(), this.startup), null)) == null || !postProcessor.getPostProcessorHelper().matchContext(contextName)) continue;
            postProcessor.injectField(field, annotation.uri(), annotation.ref(), annotation.property(), reference, beanName);
        }
        for (Field field : this.endpointFields) {
            annotation = field.getAnnotation(EndpointInject.class);
            contextName = CamelExtension.getCamelContextName(annotation.context(), this.startup);
            postProcessor = camelExtension.getPostProcessor(contextName, null);
            if (postProcessor == null || !postProcessor.getPostProcessorHelper().matchContext(contextName)) continue;
            postProcessor.injectField(field, annotation.uri(), annotation.ref(), annotation.property(), reference, beanName);
        }
    }
}

