/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.search.TermAutomatonQuery;
import org.apache.lucene.util.BytesRef;

public class TokenStreamToTermAutomatonQuery {
    private boolean preservePositionIncrements = true;

    public void setPreservePositionIncrements(boolean enablePositionIncrements) {
        this.preservePositionIncrements = enablePositionIncrements;
    }

    public TermAutomatonQuery toQuery(String field, TokenStream in) throws IOException {
        TermToBytesRefAttribute termBytesAtt = (TermToBytesRefAttribute)in.addAttribute(TermToBytesRefAttribute.class);
        PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)in.addAttribute(PositionIncrementAttribute.class);
        PositionLengthAttribute posLengthAtt = (PositionLengthAttribute)in.addAttribute(PositionLengthAttribute.class);
        OffsetAttribute offsetAtt = (OffsetAttribute)in.addAttribute(OffsetAttribute.class);
        BytesRef term = termBytesAtt.getBytesRef();
        in.reset();
        TermAutomatonQuery query = new TermAutomatonQuery(field);
        int pos = -1;
        boolean lastPos = false;
        int maxOffset = 0;
        int maxPos = -1;
        int state = -1;
        while (in.incrementToken()) {
            int posInc = posIncAtt.getPositionIncrement();
            if (!this.preservePositionIncrements && posInc > 1) {
                posInc = 1;
            }
            assert (pos > -1 || posInc > 0);
            if (posInc > 1) {
                throw new IllegalArgumentException("cannot handle holes; to accept any term, use '*' term");
            }
            if (posInc > 0) {
                pos += posInc;
            }
            int endPos = pos + posLengthAtt.getPositionLength();
            while (state < endPos) {
                state = query.createState();
            }
            termBytesAtt.fillBytesRef();
            if (term.length == 1 && term.bytes[term.offset] == 42) {
                query.addAnyTransition(pos, endPos);
            } else {
                query.addTransition(pos, endPos, term);
            }
            maxOffset = Math.max(maxOffset, offsetAtt.endOffset());
            maxPos = Math.max(maxPos, endPos);
        }
        in.end();
        query.setAccept(state, true);
        query.finish();
        return query;
    }
}

