/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanOperation {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(InfinispanOperation.class);
    private final BasicCache<Object, Object> cache;
    private final InfinispanConfiguration configuration;

    public InfinispanOperation(BasicCache<Object, Object> cache, InfinispanConfiguration configuration) {
        this.cache = cache;
        this.configuration = configuration;
    }

    public void process(Exchange exchange) {
        Operation operation = this.getOperation(exchange);
        operation.execute(this.cache, exchange);
    }

    private Operation getOperation(Exchange exchange) {
        String operation = (String)exchange.getIn().getHeader("CamelInfinispanOperation", String.class);
        if (operation == null) {
            operation = this.configuration.getCommand() != null ? "CamelInfinispanOperation" + this.configuration.getCommand() : "CamelInfinispanOperationPut";
        }
        LOGGER.trace("Operation: [{}]", (Object)operation);
        return Operation.valueOf(operation.substring("CamelInfinispanOperation".length()).toUpperCase());
    }

    static enum Operation {
        PUT{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                Object result;
                if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanLifespanTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanTimeUnit"))) {
                    long lifespan = (Long)exchange.getIn().getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    String timeUnit = (String)exchange.getIn().getHeader("CamelInfinispanTimeUnit", String.class);
                    if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit"))) {
                        long maxIdle = (Long)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        String maxIdleTimeUnit = (String)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit", String.class);
                        result = cache.put(this.getKey(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit), maxIdle, TimeUnit.valueOf(maxIdleTimeUnit));
                    } else {
                        result = cache.put(this.getKey(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit));
                    }
                } else {
                    result = cache.put(this.getKey(exchange), this.getValue(exchange));
                }
                this.setResult(result, exchange);
            }
        }
        ,
        PUTASYNC{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                NotifyingFuture result;
                if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanLifespanTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanTimeUnit"))) {
                    long lifespan = (Long)exchange.getIn().getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    String timeUnit = (String)exchange.getIn().getHeader("CamelInfinispanTimeUnit", String.class);
                    if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit"))) {
                        long maxIdle = (Long)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        String maxIdleTimeUnit = (String)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit", String.class);
                        result = cache.putAsync(this.getKey(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit), maxIdle, TimeUnit.valueOf(maxIdleTimeUnit));
                    } else {
                        result = cache.putAsync(this.getKey(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit));
                    }
                } else {
                    result = cache.putAsync(this.getKey(exchange), this.getValue(exchange));
                }
                this.setResult(result, exchange);
            }
        }
        ,
        PUTALL{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanLifespanTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanTimeUnit"))) {
                    long lifespan = (Long)exchange.getIn().getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    String timeUnit = (String)exchange.getIn().getHeader("CamelInfinispanTimeUnit", String.class);
                    if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit"))) {
                        long maxIdle = (Long)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        String maxIdleTimeUnit = (String)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit", String.class);
                        cache.putAll(this.getMap(exchange), lifespan, TimeUnit.valueOf(timeUnit), maxIdle, TimeUnit.valueOf(maxIdleTimeUnit));
                    } else {
                        cache.putAll(this.getMap(exchange), lifespan, TimeUnit.valueOf(timeUnit));
                    }
                } else {
                    cache.putAll(this.getMap(exchange));
                }
            }
        }
        ,
        PUTALLASYNC{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                NotifyingFuture result;
                if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanLifespanTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanTimeUnit"))) {
                    long lifespan = (Long)exchange.getIn().getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    String timeUnit = (String)exchange.getIn().getHeader("CamelInfinispanTimeUnit", String.class);
                    if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit"))) {
                        long maxIdle = (Long)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        String maxIdleTimeUnit = (String)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit", String.class);
                        result = cache.putAllAsync(this.getMap(exchange), lifespan, TimeUnit.valueOf(timeUnit), maxIdle, TimeUnit.valueOf(maxIdleTimeUnit));
                    } else {
                        result = cache.putAllAsync(this.getMap(exchange), lifespan, TimeUnit.valueOf(timeUnit));
                    }
                } else {
                    result = cache.putAllAsync(this.getMap(exchange));
                }
                this.setResult(result, exchange);
            }
        }
        ,
        PUTIFABSENT{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                Object result;
                if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanLifespanTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanTimeUnit"))) {
                    long lifespan = (Long)exchange.getIn().getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    String timeUnit = (String)exchange.getIn().getHeader("CamelInfinispanTimeUnit", String.class);
                    if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit"))) {
                        long maxIdle = (Long)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        String maxIdleTimeUnit = (String)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit", String.class);
                        result = cache.putIfAbsent(this.getKey(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit), maxIdle, TimeUnit.valueOf(maxIdleTimeUnit));
                    } else {
                        result = cache.putIfAbsent(this.getKey(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit));
                    }
                } else {
                    result = cache.putIfAbsent(this.getKey(exchange), this.getValue(exchange));
                }
                this.setResult(result, exchange);
            }
        }
        ,
        PUTIFABSENTASYNC{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                NotifyingFuture result;
                if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanLifespanTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanTimeUnit"))) {
                    long lifespan = (Long)exchange.getIn().getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    String timeUnit = (String)exchange.getIn().getHeader("CamelInfinispanTimeUnit", String.class);
                    if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit"))) {
                        long maxIdle = (Long)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        String maxIdleTimeUnit = (String)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit", String.class);
                        result = cache.putIfAbsentAsync(this.getKey(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit), maxIdle, TimeUnit.valueOf(maxIdleTimeUnit));
                    } else {
                        result = cache.putIfAbsentAsync(this.getKey(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit));
                    }
                } else {
                    result = cache.putIfAbsentAsync(this.getKey(exchange), this.getValue(exchange));
                }
                this.setResult(result, exchange);
            }
        }
        ,
        GET{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                Object result = cache.get(this.getKey(exchange));
                this.setResult(result, exchange);
            }
        }
        ,
        CONTAINSKEY{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                Boolean result = cache.containsKey(this.getKey(exchange));
                this.setResult(result, exchange);
            }
        }
        ,
        CONTAINSVALUE{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                Boolean result = cache.containsValue(this.getValue(exchange));
                this.setResult(result, exchange);
            }
        }
        ,
        REMOVE{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                Object result = ObjectHelper.isEmpty((Object)this.getValue(exchange)) ? cache.remove(this.getKey(exchange)) : Boolean.valueOf(cache.remove(this.getKey(exchange), this.getValue(exchange)));
                this.setResult(result, exchange);
            }
        }
        ,
        REMOVEASYNC{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                NotifyingFuture result = ObjectHelper.isEmpty((Object)this.getValue(exchange)) ? cache.removeAsync(this.getKey(exchange)) : cache.removeAsync(this.getKey(exchange), this.getValue(exchange));
                this.setResult(result, exchange);
            }
        }
        ,
        REPLACE{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                Object result;
                if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanLifespanTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanTimeUnit"))) {
                    long lifespan = (Long)exchange.getIn().getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    String timeUnit = (String)exchange.getIn().getHeader("CamelInfinispanTimeUnit", String.class);
                    if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit"))) {
                        long maxIdle = (Long)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        String maxIdleTimeUnit = (String)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit", String.class);
                        result = ObjectHelper.isEmpty((Object)this.getOldValue(exchange)) ? cache.replace(this.getKey(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit), maxIdle, TimeUnit.valueOf(maxIdleTimeUnit)) : Boolean.valueOf(cache.replace(this.getKey(exchange), this.getOldValue(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit), maxIdle, TimeUnit.valueOf(maxIdleTimeUnit)));
                    } else {
                        result = ObjectHelper.isEmpty((Object)this.getOldValue(exchange)) ? cache.replace(this.getKey(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit)) : Boolean.valueOf(cache.replace(this.getKey(exchange), this.getOldValue(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit)));
                    }
                } else {
                    result = ObjectHelper.isEmpty((Object)this.getOldValue(exchange)) ? cache.replace(this.getKey(exchange), this.getValue(exchange)) : Boolean.valueOf(cache.replace(this.getKey(exchange), this.getOldValue(exchange), this.getValue(exchange)));
                }
                this.setResult(result, exchange);
            }
        }
        ,
        REPLACEASYNC{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                NotifyingFuture result;
                if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanLifespanTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanTimeUnit"))) {
                    long lifespan = (Long)exchange.getIn().getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    String timeUnit = (String)exchange.getIn().getHeader("CamelInfinispanTimeUnit", String.class);
                    if (!ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime")) && !ObjectHelper.isEmpty((Object)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit"))) {
                        long maxIdle = (Long)exchange.getIn().getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        String maxIdleTimeUnit = (String)exchange.getIn().getHeader("CamelInfinispanMaxIdleTimeUnit", String.class);
                        result = ObjectHelper.isEmpty((Object)this.getOldValue(exchange)) ? cache.replaceAsync(this.getKey(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit), maxIdle, TimeUnit.valueOf(maxIdleTimeUnit)) : cache.replaceAsync(this.getKey(exchange), this.getOldValue(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit), maxIdle, TimeUnit.valueOf(maxIdleTimeUnit));
                    } else {
                        result = ObjectHelper.isEmpty((Object)this.getOldValue(exchange)) ? cache.replaceAsync(this.getKey(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit)) : cache.replaceAsync(this.getKey(exchange), this.getOldValue(exchange), this.getValue(exchange), lifespan, TimeUnit.valueOf(timeUnit));
                    }
                } else {
                    result = ObjectHelper.isEmpty((Object)this.getOldValue(exchange)) ? cache.replaceAsync(this.getKey(exchange), this.getValue(exchange)) : cache.replaceAsync(this.getKey(exchange), this.getOldValue(exchange), this.getValue(exchange));
                }
                this.setResult(result, exchange);
            }
        }
        ,
        SIZE{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                Integer result = cache.size();
                this.setResult(result, exchange);
            }
        }
        ,
        CLEAR{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                cache.clear();
            }
        }
        ,
        CLEARASYNC{

            @Override
            void execute(BasicCache<Object, Object> cache, Exchange exchange) {
                NotifyingFuture result = cache.clearAsync();
                this.setResult(result, exchange);
            }
        };


        void setResult(Object result, Exchange exchange) {
            exchange.getIn().setHeader("CamelInfinispanOperationResult", result);
        }

        Object getKey(Exchange exchange) {
            return exchange.getIn().getHeader("CamelInfinispanKey");
        }

        Object getValue(Exchange exchange) {
            return exchange.getIn().getHeader("CamelInfinispanValue");
        }

        Object getOldValue(Exchange exchange) {
            return exchange.getIn().getHeader("CamelInfinispanOldValue");
        }

        Map<? extends Object, ? extends Object> getMap(Exchange exchange) {
            return (Map)exchange.getIn().getHeader("CamelInfinispanMap");
        }

        abstract void execute(BasicCache<Object, Object> var1, Exchange var2);
    }
}

