/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dozer;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.dozer.DozerEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.processor.MarshalProcessor;
import org.apache.camel.processor.UnmarshalProcessor;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RouteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DozerProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DozerProducer.class);
    private DozerEndpoint endpoint;
    private UnmarshalProcessor unmarshaller;
    private MarshalProcessor marshaller;

    public DozerProducer(DozerEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        String unmarshalId = this.endpoint.getConfiguration().getUnmarshalId();
        if (unmarshalId != null) {
            LOG.debug("Unmarshalling input data using data format '{}'.", (Object)unmarshalId);
            this.resolveUnmarshaller(exchange, unmarshalId).process(exchange);
            if (exchange.getException() != null) {
                throw exchange.getException();
            }
        }
        Class targetModel = this.endpoint.getCamelContext().getClassResolver().resolveClass(this.endpoint.getConfiguration().getTargetModel());
        Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        String sourceType = this.endpoint.getConfiguration().getSourceModel();
        if (sourceType != null) {
            LOG.debug("Converting to source model {}.", (Object)sourceType);
            Class sourceModel = this.endpoint.getCamelContext().getClassResolver().resolveClass(sourceType);
            if (sourceModel == null) {
                throw new Exception("Unable to load sourceModel class: " + sourceType);
            }
            msg.setBody(msg.getBody(sourceModel));
        }
        LOG.debug("Mapping to target model {}.", (Object)targetModel.getName());
        Object targetObject = this.endpoint.getMapper().map(msg.getBody(), targetModel);
        this.endpoint.getMapper().map((Object)this.endpoint.getVariableMapper(), targetObject);
        try {
            this.endpoint.getExpressionMapper().setCurrentExchange(exchange);
            this.endpoint.getMapper().map((Object)this.endpoint.getExpressionMapper(), targetObject);
        }
        finally {
            this.endpoint.getExpressionMapper().setCurrentExchange(null);
        }
        msg.setBody(targetObject);
        exchange.setIn(msg);
        String marshalId = this.endpoint.getConfiguration().getMarshalId();
        if (marshalId != null) {
            LOG.debug("Marshalling output data using data format '{}'.", (Object)marshalId);
            this.resolveMarshaller(exchange, marshalId).process(exchange);
            if (exchange.getException() != null) {
                throw exchange.getException();
            }
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.unmarshaller != null) {
            this.unmarshaller.stop();
        }
        if (this.marshaller != null) {
            this.marshaller.stop();
        }
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.unmarshaller != null) {
            this.unmarshaller.shutdown();
        }
        if (this.marshaller != null) {
            this.marshaller.shutdown();
        }
    }

    private synchronized UnmarshalProcessor resolveUnmarshaller(Exchange exchange, String dataFormatId) throws Exception {
        if (this.unmarshaller == null) {
            DataFormat dataFormat = DataFormatDefinition.getDataFormat((RouteContext)exchange.getUnitOfWork().getRouteContext(), null, (String)dataFormatId);
            if (dataFormat == null) {
                throw new Exception("Unable to resolve data format for unmarshalling: " + dataFormatId);
            }
            this.unmarshaller = new UnmarshalProcessor(dataFormat);
            this.unmarshaller.setCamelContext(exchange.getContext());
            this.unmarshaller.start();
        }
        return this.unmarshaller;
    }

    private synchronized MarshalProcessor resolveMarshaller(Exchange exchange, String dataFormatId) throws Exception {
        if (this.marshaller == null) {
            DataFormat dataFormat = DataFormatDefinition.getDataFormat((RouteContext)exchange.getUnitOfWork().getRouteContext(), null, (String)dataFormatId);
            if (dataFormat == null) {
                throw new Exception("Unable to resolve data format for marshalling: " + dataFormatId);
            }
            this.marshaller = new MarshalProcessor(dataFormat);
            this.marshaller.setCamelContext(exchange.getContext());
            this.marshaller.start();
        }
        return this.marshaller;
    }
}

