/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.concurrent.ExecutorService;
import javax.jms.Connection;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateConsumerException;
import org.apache.camel.Processor;
import org.apache.camel.SuspendableService;
import org.apache.camel.component.jms.EndpointMessageListener;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.springframework.jms.listener.AbstractMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;

public class JmsConsumer
extends DefaultConsumer
implements SuspendableService {
    private volatile AbstractMessageListenerContainer listenerContainer;
    private volatile EndpointMessageListener messageListener;
    private volatile boolean initialized;
    private volatile ExecutorService executorService;
    private volatile boolean shutdownExecutorService;

    public JmsConsumer(JmsEndpoint endpoint, Processor processor, AbstractMessageListenerContainer listenerContainer) {
        super((Endpoint)endpoint, processor);
        this.listenerContainer = listenerContainer;
        this.listenerContainer.setMessageListener((Object)this.getEndpointMessageListener());
    }

    public JmsEndpoint getEndpoint() {
        return (JmsEndpoint)super.getEndpoint();
    }

    public AbstractMessageListenerContainer getListenerContainer() throws Exception {
        if (this.listenerContainer == null) {
            this.createMessageListenerContainer();
        }
        return this.listenerContainer;
    }

    public EndpointMessageListener getEndpointMessageListener() {
        if (this.messageListener == null) {
            this.createMessageListener(this.getEndpoint(), this.getProcessor());
        }
        return this.messageListener;
    }

    protected void createMessageListener(JmsEndpoint endpoint, Processor processor) {
        this.messageListener = new EndpointMessageListener(endpoint, processor);
        this.getEndpoint().getConfiguration().configureMessageListener(this.messageListener);
        this.messageListener.setBinding(endpoint.getBinding());
        this.messageListener.setAsync(endpoint.getConfiguration().isAsyncConsumer());
    }

    protected void createMessageListenerContainer() throws Exception {
        this.listenerContainer = this.getEndpoint().createMessageListenerContainer();
        this.getEndpoint().configureListenerContainer(this.listenerContainer, this);
        this.listenerContainer.setMessageListener((Object)this.getEndpointMessageListener());
    }

    void setListenerContainerExecutorService(ExecutorService executorService, boolean shutdownExecutorService) {
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
    }

    public void startListenerContainer() {
        this.log.trace("Starting listener container {} on destination {}", (Object)this.listenerContainer, (Object)this.getDestinationName());
        this.listenerContainer.start();
        this.log.debug("Started listener container {} on destination {}", (Object)this.listenerContainer, (Object)this.getDestinationName());
    }

    protected void testConnectionOnStartup() throws FailedToCreateConsumerException {
        try {
            this.log.debug("Testing JMS Connection on startup for destination: {}", (Object)this.getDestinationName());
            Connection con = this.listenerContainer.getConnectionFactory().createConnection();
            JmsUtils.closeConnection((Connection)con);
            this.log.debug("Successfully tested JMS Connection on startup for destination: {}", (Object)this.getDestinationName());
        }
        catch (Exception e) {
            String msg = "Cannot get JMS Connection on startup for destination " + this.getDestinationName();
            throw new FailedToCreateConsumerException((Endpoint)this.getEndpoint(), msg, (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.listenerContainer == null) {
            this.createMessageListenerContainer();
        }
        this.getEndpoint().onListenerContainerStarting(this.listenerContainer);
        if (this.getEndpoint().getConfiguration().isAsyncStartListener()) {
            this.getEndpoint().getAsyncStartStopExecutorService().submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        JmsConsumer.this.prepareAndStartListenerContainer();
                    }
                    catch (Throwable e) {
                        JmsConsumer.this.log.warn("Error starting listener container on destination: " + JmsConsumer.this.getDestinationName() + ". This exception will be ignored.", e);
                    }
                }

                public String toString() {
                    return "AsyncStartListenerTask[" + JmsConsumer.this.getDestinationName() + "]";
                }
            });
        } else {
            this.prepareAndStartListenerContainer();
        }
        this.initialized = true;
    }

    protected void prepareAndStartListenerContainer() {
        this.listenerContainer.afterPropertiesSet();
        if (this.initialized || this.getEndpoint().isAutoStartup()) {
            if (this.getEndpoint().isTestConnectionOnStartup()) {
                this.testConnectionOnStartup();
            }
            this.startListenerContainer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopAndDestroyListenerContainer() {
        if (this.listenerContainer != null) {
            try {
                this.listenerContainer.stop();
                this.listenerContainer.destroy();
            }
            finally {
                this.getEndpoint().onListenerContainerStopped(this.listenerContainer);
            }
        }
        this.listenerContainer = null;
        this.messageListener = null;
        if (this.shutdownExecutorService && this.executorService != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
        this.executorService = null;
    }

    protected void doStop() throws Exception {
        if (this.listenerContainer != null) {
            if (this.getEndpoint().getConfiguration().isAsyncStopListener()) {
                this.getEndpoint().getAsyncStartStopExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JmsConsumer.this.stopAndDestroyListenerContainer();
                        }
                        catch (Throwable e) {
                            JmsConsumer.this.log.warn("Error stopping listener container on destination: " + JmsConsumer.this.getDestinationName() + ". This exception will be ignored.", e);
                        }
                    }

                    public String toString() {
                        return "AsyncStopListenerTask[" + JmsConsumer.this.getDestinationName() + "]";
                    }
                });
            } else {
                this.stopAndDestroyListenerContainer();
            }
        }
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
        }
    }

    protected void doResume() throws Exception {
        if (this.listenerContainer != null) {
            this.startListenerContainer();
        }
    }

    private String getDestinationName() {
        if (this.listenerContainer.getDestination() != null) {
            return this.listenerContainer.getDestination().toString();
        }
        return this.listenerContainer.getDestinationName();
    }
}

