/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.service;

import org.apache.camel.CamelContext;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.wildfly.camel.CamelConstants;
import org.wildfly.camel.CamelContextRegistry;
import org.wildfly.camel.CamelLogger;
import org.wildfly.camel.CamelMessages;
import org.wildfly.camel.SpringCamelContextFactory;
import org.wildfly.camel.parser.SubsystemState;
import org.wildfly.camel.service.CamelContextRegistryBindingService;

public class CamelContextRegistryService
extends AbstractService<CamelContextRegistry> {
    private static final String SPRING_BEANS_HEADER = "<beans xmlns='http://www.springframework.org/schema/beans' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd'>";
    private final SubsystemState subsystemState;
    private CamelContextRegistry contextRegistry;

    public static ServiceController<CamelContextRegistry> addService(ServiceTarget serviceTarget, SubsystemState subsystemState, ServiceVerificationHandler verificationHandler) {
        CamelContextRegistryService service = new CamelContextRegistryService(subsystemState);
        ServiceBuilder builder = serviceTarget.addService(CamelConstants.CAMEL_CONTEXT_REGISTRY_SERVICE_NAME, (Service)service);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    private CamelContextRegistryService(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    public void start(StartContext startContext) throws StartException {
        ServiceContainer serviceContainer = startContext.getController().getServiceContainer();
        ServiceTarget serviceTarget = startContext.getChildTarget();
        this.contextRegistry = new DefaultCamelContextRegistry(serviceContainer, serviceTarget);
        for (String name : this.subsystemState.getContextDefinitionNames()) {
            CamelContext camelctx;
            try {
                ClassLoader classLoader = CamelContextRegistry.class.getClassLoader();
                String beansXML = this.getBeansXML(name, this.subsystemState.getContextDefinition(name));
                camelctx = SpringCamelContextFactory.createSpringCamelContext(beansXML.getBytes(), classLoader);
            }
            catch (Exception ex) {
                throw CamelMessages.MESSAGES.cannotCreateCamelContext(ex, name);
            }
            this.contextRegistry.registerCamelContext(camelctx);
        }
    }

    public CamelContextRegistry getValue() {
        return this.contextRegistry;
    }

    private String getBeansXML(String name, String contextDefinition) {
        String hashReplaced = contextDefinition.replace("#{", "${");
        return "<beans xmlns='http://www.springframework.org/schema/beans' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd'><camelContext id='" + name + "' xmlns='http://camel.apache.org/schema/spring'>" + hashReplaced + "</camelContext></beans>";
    }

    class DefaultCamelContextRegistry
    implements CamelContextRegistry {
        private final ServiceContainer serviceContainer;
        private final ServiceTarget serviceTarget;

        DefaultCamelContextRegistry(ServiceContainer serviceContainer, ServiceTarget serviceTarget) {
            this.serviceContainer = serviceContainer;
            this.serviceTarget = serviceTarget;
        }

        @Override
        public CamelContext getCamelContext(String name) {
            ServiceController controller = this.serviceContainer.getService(this.getInternalServiceName(name));
            return controller != null ? (CamelContext)controller.getValue() : null;
        }

        @Override
        public CamelContextRegistry.CamelContextRegistration registerCamelContext(final CamelContext camelctx) {
            String name = camelctx.getName();
            if (this.getCamelContext(name) != null) {
                throw CamelMessages.MESSAGES.camelContextAlreadyRegistered(name);
            }
            CamelLogger.LOGGER.infoRegisterCamelContext(name);
            ValueService service = new ValueService((Value)new ImmediateValue((Object)camelctx));
            ServiceBuilder builder = this.serviceTarget.addService(this.getInternalServiceName(name), (Service)service);
            builder.addDependency(CamelContextRegistryBindingService.getBinderServiceName());
            final ServiceController controller = builder.install();
            return new CamelContextRegistry.CamelContextRegistration(){

                @Override
                public CamelContext getCamelContext() {
                    return camelctx;
                }

                @Override
                public void unregister() {
                    controller.setMode(ServiceController.Mode.REMOVE);
                }
            };
        }

        private ServiceName getInternalServiceName(String name) {
            return CamelConstants.CAMEL_CONTEXT_BASE_NAME.append(new String[]{name});
        }
    }
}

