/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.deployment;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.wildfly.extension.gravia.GraviaConstants;

public class ModuleDependenciesProcessor
implements DeploymentUnitProcessor {
    private static final List<ModuleDependency> systemDependencies = new ArrayList<ModuleDependency>();

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        if (depUnit.hasAttachment(GraviaConstants.RESOURCE_KEY)) {
            ModuleSpecification moduleSpecification = (ModuleSpecification)depUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            moduleSpecification.addSystemDependencies(systemDependencies);
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
    }

    static {
        systemDependencies.add(new ModuleDependency(Module.getBootModuleLoader(), ModuleIdentifier.create((String)"org.osgi.core"), false, false, false, false));
        systemDependencies.add(new ModuleDependency(Module.getBootModuleLoader(), ModuleIdentifier.create((String)"org.osgi.enterprise"), false, false, false, false));
        systemDependencies.add(new ModuleDependency(Module.getBootModuleLoader(), ModuleIdentifier.create((String)"org.jboss.gravia"), false, false, false, false));
    }
}

