/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.deployment;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleException;
import org.wildfly.extension.gravia.GraviaConstants;
import org.wildfly.extension.gravia.GraviaExtensionLogger;

public class ModuleStartProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit depUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)depUnit.getAttachment(GraviaConstants.MODULE_KEY);
        if (module != null) {
            try {
                module.start();
            }
            catch (ModuleException ex) {
                throw new DeploymentUnitProcessingException((Throwable)ex);
            }
        }
    }

    public void undeploy(DeploymentUnit depUnit) {
        Module module = (Module)depUnit.getAttachment(GraviaConstants.MODULE_KEY);
        if (module != null && module.getState() != Module.State.UNINSTALLED) {
            try {
                module.stop();
            }
            catch (ModuleException ex) {
                GraviaExtensionLogger.LOGGER.error("Cannot stop module: " + module, (Throwable)ex);
            }
        }
    }
}

