/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.api.config.PropertyFileConfig;
import org.apache.deltaspike.core.impl.config.EnvironmentPropertyConfigSourceProvider;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.spi.config.ConfigSource;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;

public class ConfigurationExtension
implements Extension,
Deactivatable {
    private static final String CANNOT_CREATE_CONFIG_SOURCE_FOR_CUSTOM_PROPERTY_FILE_CONFIG = "Cannot create ConfigSource for custom property-file config ";
    private boolean isActivated = true;
    private List<Class<? extends PropertyFileConfig>> configSourcesClasses = new ArrayList<Class<? extends PropertyFileConfig>>();

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
    }

    public void collectUserConfigSources(@Observes ProcessAnnotatedType<? extends PropertyFileConfig> pat) {
        if (!this.isActivated) {
            return;
        }
        Class pcsClass = pat.getAnnotatedType().getJavaClass();
        if (pcsClass.isAnnotation() || pcsClass.isInterface() || pcsClass.isSynthetic() || pcsClass.isArray() || pcsClass.isEnum()) {
            return;
        }
        this.configSourcesClasses.add(pcsClass);
    }

    public void registerUserConfigSources(@Observes AfterDeploymentValidation adv) {
        if (!this.isActivated) {
            return;
        }
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        for (Class<? extends PropertyFileConfig> propertyFileConfigClass : this.configSourcesClasses) {
            configSources.addAll(this.createPropertyConfigSource(propertyFileConfigClass));
        }
        ConfigResolver.addConfigSources(configSources);
    }

    public void freeConfigSources(@Observes BeforeShutdown bs) {
        ConfigResolver.freeConfigSources();
    }

    private List<ConfigSource> createPropertyConfigSource(Class<? extends PropertyFileConfig> propertyFileConfigClass) {
        try {
            PropertyFileConfig propertyFileConfig = propertyFileConfigClass.newInstance();
            EnvironmentPropertyConfigSourceProvider environmentPropertyConfigSourceProvider = new EnvironmentPropertyConfigSourceProvider(propertyFileConfig.getPropertyFileName());
            return environmentPropertyConfigSourceProvider.getConfigSources();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(CANNOT_CREATE_CONFIG_SOURCE_FOR_CUSTOM_PROPERTY_FILE_CONFIG + propertyFileConfigClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(CANNOT_CREATE_CONFIG_SOURCE_FOR_CUSTOM_PROPERTY_FILE_CONFIG + propertyFileConfigClass.getName(), e);
        }
    }
}

