/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.SubExpressionInfo;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Assignation
extends Expression
implements Binding {
    protected int slotNumber = -999;
    protected Expression sequence;
    protected Expression action;
    protected StructuredQName variableName;
    protected SequenceType requiredType;
    int refCount = 2;

    public void setRequiredType(SequenceType requiredType) {
        this.requiredType = requiredType;
    }

    public void setVariableQName(StructuredQName variableName) {
        this.variableName = variableName;
    }

    @Override
    public StructuredQName getVariableQName() {
        return this.variableName;
    }

    @Override
    public StructuredQName getObjectName() {
        return this.variableName;
    }

    @Override
    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    @Override
    public IntegerValue[] getIntegerBoundsForVariable() {
        return this.sequence.getIntegerBounds();
    }

    @Override
    public int getLocalSlotNumber() {
        return this.slotNumber;
    }

    @Override
    public Sequence evaluateVariable(XPathContext context) throws XPathException {
        Sequence actual = context.evaluateLocalVariable(this.slotNumber);
        if (!(actual instanceof GroundedValue) && !(actual instanceof NodeInfo)) {
            actual = SequenceTool.toGroundedValue(actual);
            context.setLocalVariable(this.slotNumber, actual);
        }
        return actual;
    }

    public void setAction(Expression action) {
        this.action = action;
        this.adoptChildExpression(action);
    }

    @Override
    public final boolean isGlobal() {
        return false;
    }

    @Override
    public final boolean isAssignable() {
        return false;
    }

    @Override
    public void checkForUpdatingSubexpressions() throws XPathException {
        this.sequence.checkForUpdatingSubexpressions();
        if (this.sequence.isUpdatingExpression()) {
            XPathException err = new XPathException("An updating expression cannot be used to initialize a variable", "XUST0001");
            err.setLocator(this.sequence);
            throw err;
        }
        this.action.checkForUpdatingSubexpressions();
    }

    @Override
    public boolean isUpdatingExpression() {
        return this.action.isUpdatingExpression();
    }

    public Expression getAction() {
        return this.action;
    }

    public void setSequence(Expression sequence) {
        this.sequence = sequence;
        this.adoptChildExpression(sequence);
    }

    public Expression getSequence() {
        return this.sequence;
    }

    public void setSlotNumber(int nr) {
        this.slotNumber = nr;
    }

    public int getRequiredSlots() {
        return 1;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.sequence = visitor.simplify(this.sequence);
        this.action = visitor.simplify(this.action);
        return this;
    }

    @Override
    public boolean hasVariableBinding(Binding binding) {
        return this == binding;
    }

    @Override
    public Expression promote(PromotionOffer offer, Expression parent) throws XPathException {
        Expression exp = offer.accept(parent, this);
        if (exp != null) {
            return exp;
        }
        this.sequence = this.doPromotion(this.sequence, offer);
        if (offer.action == 12 || offer.action == 13 || offer.action == 14) {
            this.action = this.doPromotion(this.action, offer);
        } else if (offer.action == 11 || offer.action == 10) {
            Binding[] savedBindingList = offer.bindingList;
            offer.bindingList = this.extendBindingList(offer.bindingList);
            this.action = this.doPromotion(this.action, offer);
            offer.bindingList = savedBindingList;
        }
        return this;
    }

    @Override
    public Expression unordered(boolean retainAllNodes) throws XPathException {
        this.action = this.action.unordered(retainAllNodes);
        return this;
    }

    @Override
    public void suppressValidation(int validationMode) {
        this.action.suppressValidation(validationMode);
    }

    public Binding[] extendBindingList(Binding[] in) {
        Binding[] newBindingList;
        if (in == null) {
            newBindingList = new Binding[1];
        } else {
            newBindingList = new Binding[in.length + 1];
            System.arraycopy(in, 0, newBindingList, 0, in.length);
        }
        newBindingList[newBindingList.length - 1] = this;
        return newBindingList;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator<Expression>(this.sequence, this.action);
    }

    @Override
    public Iterator<SubExpressionInfo> iterateSubExpressionInfo() {
        SubExpressionInfo sequenceInfo = new SubExpressionInfo(this.sequence, true, false, 3);
        SubExpressionInfo actionInfo = new SubExpressionInfo(this.action, true, !(this instanceof LetExpression), 2);
        return new PairIterator<SubExpressionInfo>(sequenceInfo, actionInfo);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.sequence == original) {
            this.sequence = replacement;
            found = true;
        }
        if (this.action == original) {
            this.action = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet varPath = this.sequence.addToPathMap(pathMap, pathMapNodeSet);
        pathMap.registerPathForVariable(this, varPath);
        return this.action.addToPathMap(pathMap, pathMapNodeSet);
    }

    public String getVariableName() {
        if (this.variableName == null) {
            return "zz:var" + this.hashCode();
        }
        return this.variableName.getDisplayName();
    }

    public String getVariableEQName() {
        if (this.variableName == null) {
            return "Q{http://ns.saxonica.com/anonymous-var}var" + this.hashCode();
        }
        if (this.variableName.isInNamespace("")) {
            return this.variableName.getLocalPart();
        }
        return this.variableName.getEQName();
    }

    public void refineTypeInformation(ItemType type, int cardinality, GroundedValue constantValue, int properties, ExpressionVisitor visitor, Assignation currentExpression) {
        ArrayList<VariableReference> references = new ArrayList<VariableReference>();
        ExpressionTool.gatherVariableReferences(currentExpression.getAction(), this, references);
        for (BindingReference bindingReference : references) {
            if (!(bindingReference instanceof VariableReference)) continue;
            ((VariableReference)bindingReference).refineVariableType(type, cardinality, constantValue, properties, visitor);
            visitor.resetStaticProperties();
        }
    }

    @Override
    public void addReference(boolean isLoopingReference) {
        if (this.refCount != 10000) {
            this.refCount += isLoopingReference ? 10 : 1;
        }
    }

    public int getNominalReferenceCount() {
        return this.refCount;
    }

    public boolean isIndexedVariable() {
        return this.refCount == 10000;
    }

    public void replaceVariable(Optimizer opt, Expression seq) throws XPathException {
        Binding newBinding;
        PromotionOffer offer2 = new PromotionOffer(opt);
        offer2.action = 12;
        offer2.bindingList = new Binding[]{this};
        offer2.containingExpression = seq;
        this.action = this.doPromotion(this.action, offer2);
        if (offer2.accepted) {
            offer2.accepted = false;
            this.replaceVariable(opt, seq);
        }
        if (this.isIndexedVariable() && seq instanceof VariableReference && (newBinding = ((VariableReference)seq).getBinding()) instanceof Assignation) {
            ((Assignation)newBinding).setIndexedVariable();
        }
    }

    public void setIndexedVariable() {
        this.refCount = 10000;
    }
}

