/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelContextFactory;
import org.wildfly.extension.camel.CamelLogger;

public final class CamelContextFactoryBindingService {
    public static ServiceController<?> addService(ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler) {
        final ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)"java:jboss/camel/CamelContextFactory");
        BinderService binderService = new BinderService(bindInfo.getBindName()){

            public synchronized void start(StartContext context) throws StartException {
                super.start(context);
                CamelLogger.LOGGER.info("Bound camel naming object: {}", (Object)bindInfo.getAbsoluteJndiName());
            }

            public synchronized void stop(StopContext context) {
                CamelLogger.LOGGER.debug("Unbind camel naming object: {}", (Object)bindInfo.getAbsoluteJndiName());
                super.stop(context);
            }
        };
        InjectedValue injector = binderService.getManagedObjectInjector();
        ServiceBuilder builder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService);
        builder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector());
        builder.addDependency(CamelConstants.CAMEL_CONTEXT_FACTORY_SERVICE_NAME, CamelContextFactory.class, (Injector)new ManagedReferenceInjector((Injector)injector));
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }
}

