/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.service;

import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.cdi.CdiCamelContext;
import org.apache.camel.management.event.CamelContextStartedEvent;
import org.apache.camel.management.event.CamelContextStoppedEvent;
import org.apache.camel.spi.Container;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.support.EventNotifierSupport;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.wildfly.extension.camel.CamelConstants;
import org.wildfly.extension.camel.CamelContextRegistry;
import org.wildfly.extension.camel.CamelLogger;
import org.wildfly.extension.camel.SpringCamelContextFactory;
import org.wildfly.extension.camel.parser.SubsystemState;

public class CamelContextRegistryService
extends AbstractService<CamelContextRegistry> {
    private static final String SPRING_BEANS_HEADER = "<beans xmlns='http://www.springframework.org/schema/beans' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd'>";
    private final SubsystemState subsystemState;
    private CamelContextRegistry contextRegistry;

    public static ServiceController<CamelContextRegistry> addService(ServiceTarget serviceTarget, SubsystemState subsystemState, ServiceVerificationHandler verificationHandler) {
        CamelContextRegistryService service = new CamelContextRegistryService(subsystemState);
        ServiceBuilder builder = serviceTarget.addService(CamelConstants.CAMEL_CONTEXT_REGISTRY_SERVICE_NAME, (Service)service);
        builder.addListener((ServiceListener)verificationHandler);
        return builder.install();
    }

    private CamelContextRegistryService(SubsystemState subsystemState) {
        this.subsystemState = subsystemState;
    }

    public void start(StartContext startContext) throws StartException {
        this.contextRegistry = new DefaultCamelContextRegistry();
        for (String name : this.subsystemState.getContextDefinitionNames()) {
            try {
                ClassLoader classLoader = CamelContextRegistry.class.getClassLoader();
                String beansXML = this.getBeansXML(name, this.subsystemState.getContextDefinition(name));
                SpringCamelContextFactory.createSpringCamelContext(beansXML.getBytes(), classLoader);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Cannot create camel context: " + name, ex);
            }
        }
    }

    public CamelContextRegistry getValue() {
        return this.contextRegistry;
    }

    private String getBeansXML(String name, String contextDefinition) {
        String hashReplaced = contextDefinition.replace("#{", "${");
        return "<beans xmlns='http://www.springframework.org/schema/beans' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans.xsd http://camel.apache.org/schema/spring http://camel.apache.org/schema/spring/camel-spring.xsd'><camelContext id='" + name + "' xmlns='http://camel.apache.org/schema/spring'>" + hashReplaced + "</camelContext></beans>";
    }

    class DefaultCamelContextRegistry
    implements CamelContextRegistry,
    Container {
        final Set<CamelContext> contexts = new HashSet<CamelContext>();

        DefaultCamelContextRegistry() {
            Container.Instance.set((Container)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CamelContext getContext(String name) {
            CamelContext result = null;
            Set<CamelContext> set = this.contexts;
            synchronized (set) {
                for (CamelContext camelctx : this.contexts) {
                    if (!camelctx.getName().equals(name)) continue;
                    result = camelctx;
                    break;
                }
            }
            return result;
        }

        public void manage(CamelContext camelctx) {
            this.registerCamelContext(camelctx);
        }

        private void registerCamelContext(CamelContext camelctx) {
            if (camelctx instanceof CdiCamelContext) {
                return;
            }
            ManagementStrategy mgmtStrategy = camelctx.getManagementStrategy();
            mgmtStrategy.addEventNotifier((EventNotifier)new EventNotifierSupport(){

                public void notify(EventObject event) throws Exception {
                    if (event instanceof CamelContextStartedEvent) {
                        CamelContextStartedEvent camelevt = (CamelContextStartedEvent)event;
                        CamelContext camelctx = camelevt.getContext();
                        CamelLogger.LOGGER.info("Camel context started: {}", (Object)camelctx);
                        DefaultCamelContextRegistry.this.addContext(camelctx);
                    } else if (event instanceof CamelContextStoppedEvent) {
                        CamelContextStoppedEvent camelevt = (CamelContextStoppedEvent)event;
                        CamelContext camelctx = camelevt.getContext();
                        CamelLogger.LOGGER.info("Camel context stopped: {}", (Object)camelctx);
                        DefaultCamelContextRegistry.this.removeContext(camelctx);
                    }
                }

                public boolean isEnabled(EventObject event) {
                    return event instanceof CamelContextStartedEvent || event instanceof CamelContextStoppedEvent;
                }
            });
            this.addContext(camelctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addContext(CamelContext camelctx) {
            Set<CamelContext> set = this.contexts;
            synchronized (set) {
                this.contexts.add(camelctx);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeContext(CamelContext camelctx) {
            Set<CamelContext> set = this.contexts;
            synchronized (set) {
                this.contexts.remove(camelctx);
            }
        }
    }
}

