/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.idempotent.jdbc;

import java.sql.Timestamp;
import javax.sql.DataSource;
import org.apache.camel.processor.idempotent.jdbc.AbstractJdbcMessageIdRepository;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class JdbcMessageIdRepository
extends AbstractJdbcMessageIdRepository<String> {
    private boolean createTableIfNotExists = true;
    private String tableExistsString = "SELECT 1 FROM CAMEL_MESSAGEPROCESSED WHERE 1 = 0";
    private String createString = "CREATE TABLE CAMEL_MESSAGEPROCESSED (processorName VARCHAR(255), messageId VARCHAR(100), createdAt TIMESTAMP)";
    private String queryString = "SELECT COUNT(*) FROM CAMEL_MESSAGEPROCESSED WHERE processorName = ? AND messageId = ?";
    private String insertString = "INSERT INTO CAMEL_MESSAGEPROCESSED (processorName, messageId, createdAt) VALUES (?, ?, ?)";
    private String deleteString = "DELETE FROM CAMEL_MESSAGEPROCESSED WHERE processorName = ? AND messageId = ?";

    public JdbcMessageIdRepository() {
    }

    public JdbcMessageIdRepository(DataSource dataSource, String processorName) {
        super(dataSource, processorName);
    }

    public JdbcMessageIdRepository(DataSource dataSource, TransactionTemplate transactionTemplate, String processorName) {
        super(dataSource, transactionTemplate, processorName);
    }

    public JdbcMessageIdRepository(JdbcTemplate jdbcTemplate, TransactionTemplate transactionTemplate) {
        super(jdbcTemplate, transactionTemplate);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction(TransactionStatus status) {
                try {
                    JdbcMessageIdRepository.this.jdbcTemplate.execute(JdbcMessageIdRepository.this.tableExistsString);
                    JdbcMessageIdRepository.this.log.debug("Expected table for JdbcMessageIdRepository exist");
                }
                catch (DataAccessException e) {
                    if (JdbcMessageIdRepository.this.createTableIfNotExists) {
                        try {
                            JdbcMessageIdRepository.this.log.debug("creating table for JdbcMessageIdRepository because it doesn't exist...");
                            JdbcMessageIdRepository.this.jdbcTemplate.execute(JdbcMessageIdRepository.this.createString);
                            JdbcMessageIdRepository.this.log.info("table created with query '{}'", (Object)JdbcMessageIdRepository.this.createString);
                        }
                        catch (DataAccessException dae) {
                            JdbcMessageIdRepository.this.log.error("Can't create table for JdbcMessageIdRepository with query '{}' because of: {}. This may be a permissions problem. Please create this table and try again.", (Object)JdbcMessageIdRepository.this.createString, (Object)e.getMessage());
                            throw dae;
                        }
                    }
                    throw e;
                }
                return Boolean.TRUE;
            }
        });
    }

    @Override
    protected int queryForInt(String key) {
        return (Integer)this.jdbcTemplate.queryForObject(this.queryString, Integer.class, new Object[]{this.processorName, key});
    }

    @Override
    protected int insert(String key) {
        return this.jdbcTemplate.update(this.insertString, new Object[]{this.processorName, key, new Timestamp(System.currentTimeMillis())});
    }

    @Override
    protected int delete(String key) {
        return this.jdbcTemplate.update(this.deleteString, new Object[]{this.processorName, key});
    }

    public boolean isCreateTableIfNotExists() {
        return this.createTableIfNotExists;
    }

    public void setCreateTableIfNotExists(boolean createTableIfNotExists) {
        this.createTableIfNotExists = createTableIfNotExists;
    }

    public String getTableExistsString() {
        return this.tableExistsString;
    }

    public void setTableExistsString(String tableExistsString) {
        this.tableExistsString = tableExistsString;
    }

    public String getCreateString() {
        return this.createString;
    }

    public void setCreateString(String createString) {
        this.createString = createString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getInsertString() {
        return this.insertString;
    }

    public void setInsertString(String insertString) {
        this.insertString = insertString;
    }

    public String getDeleteString() {
        return this.deleteString;
    }

    public void setDeleteString(String deleteString) {
        this.deleteString = deleteString;
    }
}

