/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.PollingConsumerPollingStrategy;
import org.apache.camel.Processor;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.impl.PollingConsumerSupport;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDrivenPollingConsumer
extends PollingConsumerSupport
implements Processor {
    private static final Logger LOG = LoggerFactory.getLogger(EventDrivenPollingConsumer.class);
    private final BlockingQueue<Exchange> queue;
    private ExceptionHandler interruptedExceptionHandler;
    private Consumer consumer;
    private boolean blockWhenFull = true;
    private final int queueCapacity;

    public EventDrivenPollingConsumer(Endpoint endpoint) {
        this(endpoint, 1000);
    }

    public EventDrivenPollingConsumer(Endpoint endpoint, int queueSize) {
        super(endpoint);
        this.queueCapacity = queueSize;
        this.queue = queueSize <= 0 ? new LinkedBlockingQueue<Exchange>() : new ArrayBlockingQueue<Exchange>(queueSize);
        this.interruptedExceptionHandler = new LoggingExceptionHandler(endpoint.getCamelContext(), EventDrivenPollingConsumer.class);
    }

    public EventDrivenPollingConsumer(Endpoint endpoint, BlockingQueue<Exchange> queue) {
        super(endpoint);
        this.queue = queue;
        this.queueCapacity = queue.remainingCapacity();
        this.interruptedExceptionHandler = new LoggingExceptionHandler(endpoint.getCamelContext(), EventDrivenPollingConsumer.class);
    }

    public boolean isBlockWhenFull() {
        return this.blockWhenFull;
    }

    public void setBlockWhenFull(boolean blockWhenFull) {
        this.blockWhenFull = blockWhenFull;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public int getQueueSize() {
        return this.queue.size();
    }

    @Override
    public Exchange receiveNoWait() {
        return this.receive(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exchange receive() {
        if (!this.isRunAllowed() || !this.isStarted()) {
            throw new RejectedExecutionException(this + " is not started, but in state: " + this.getStatus().name());
        }
        while (this.isRunAllowed()) {
            try {
                this.beforePoll(0L);
                Exchange exchange = this.queue.take();
                return exchange;
            }
            catch (InterruptedException e) {
                this.handleInterruptedException(e);
            }
            finally {
                this.afterPoll();
            }
        }
        LOG.trace("Consumer is not running, so returning null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exchange receive(long timeout) {
        if (!this.isRunAllowed() || !this.isStarted()) {
            throw new RejectedExecutionException(this + " is not started, but in state: " + this.getStatus().name());
        }
        try {
            timeout = this.beforePoll(timeout);
            Exchange exchange = this.queue.poll(timeout, TimeUnit.MILLISECONDS);
            return exchange;
        }
        catch (InterruptedException e) {
            this.handleInterruptedException(e);
            Exchange exchange = null;
            return exchange;
        }
        finally {
            this.afterPoll();
        }
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.isBlockWhenFull()) {
            try {
                this.queue.put(exchange);
            }
            catch (InterruptedException e) {
                this.log.debug("Put interrupted, are we stopping? {}", (Object)(this.isStopping() || this.isStopped() ? 1 : 0));
            }
        } else {
            this.queue.add(exchange);
        }
    }

    public ExceptionHandler getInterruptedExceptionHandler() {
        return this.interruptedExceptionHandler;
    }

    public void setInterruptedExceptionHandler(ExceptionHandler interruptedExceptionHandler) {
        this.interruptedExceptionHandler = interruptedExceptionHandler;
    }

    protected void handleInterruptedException(InterruptedException e) {
        this.getInterruptedExceptionHandler().handleException(e);
    }

    protected long beforePoll(long timeout) {
        if (this.consumer instanceof PollingConsumerPollingStrategy) {
            PollingConsumerPollingStrategy strategy = (PollingConsumerPollingStrategy)((Object)this.consumer);
            try {
                timeout = strategy.beforePoll(timeout);
            }
            catch (Exception e) {
                LOG.debug("Error occurred before polling " + this.consumer + ". This exception will be ignored.", (Throwable)e);
            }
        }
        return timeout;
    }

    protected void afterPoll() {
        if (this.consumer instanceof PollingConsumerPollingStrategy) {
            PollingConsumerPollingStrategy strategy = (PollingConsumerPollingStrategy)((Object)this.consumer);
            try {
                strategy.afterPoll();
            }
            catch (Exception e) {
                LOG.debug("Error occurred after polling " + this.consumer + ". This exception will be ignored.", (Throwable)e);
            }
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.consumer = this.getEndpoint().createConsumer(this);
        if (this.consumer instanceof PollingConsumerPollingStrategy) {
            PollingConsumerPollingStrategy strategy = (PollingConsumerPollingStrategy)((Object)this.consumer);
            strategy.onInit();
        } else {
            ServiceHelper.startService(this.consumer);
        }
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.consumer);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.consumer);
        this.queue.clear();
    }
}

