/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.apache.camel.model.ModelHelper;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.util.ObjectHelper;

public final class RoutesXml {
    private RoutesXml() {
    }

    public static RoutesDefinition loadRoutesFromXML(String xml) throws JAXBException {
        return (RoutesDefinition)ModelHelper.createModelFromXml((String)xml, RoutesDefinition.class);
    }

    public static RoutesDefinition loadRoutesFromClasspath(String uri) throws JAXBException {
        InputStream stream = ObjectHelper.loadResourceAsStream((String)uri);
        ObjectHelper.notNull((Object)stream, (String)("Could not find resource '" + uri + "' on the ClassLoader"));
        return (RoutesDefinition)ModelHelper.createModelFromXml((InputStream)stream, RoutesDefinition.class);
    }

    public static RoutesDefinition loadRoutesFromURL(URL url) throws JAXBException, IOException {
        ObjectHelper.notNull((Object)url, (String)"url");
        return (RoutesDefinition)ModelHelper.createModelFromXml((InputStream)url.openStream(), RoutesDefinition.class);
    }

    public static RoutesDefinition loadRoutesFromURL(String url) throws IOException, JAXBException {
        return RoutesXml.loadRoutesFromURL(new URL(url));
    }

    public static RoutesDefinition loadRoutesFromFile(File file) throws JAXBException, FileNotFoundException {
        ObjectHelper.notNull((Object)file, (String)"file");
        return (RoutesDefinition)ModelHelper.createModelFromXml((InputStream)new FileInputStream(file), RoutesDefinition.class);
    }

    public static RoutesDefinition loadRoutesFromFile(String fileName) throws JAXBException, FileNotFoundException {
        return RoutesXml.loadRoutesFromFile(new File(fileName));
    }
}

