/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import org.apache.camel.component.hl7.HL7MLLPConfig;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.CumulativeProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HL7MLLPDecoder
extends CumulativeProtocolDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(HL7MLLPDecoder.class);
    private static final String CHARSET_DECODER = HL7MLLPDecoder.class.getName() + ".charsetdecoder";
    private static final String DECODER_STATE = HL7MLLPDecoder.class.getName() + ".STATE";
    private HL7MLLPConfig config;

    HL7MLLPDecoder(HL7MLLPConfig config) {
        this.config = config;
    }

    protected boolean doDecode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) {
        boolean foundEnd = this.scan(session, in);
        if (foundEnd) {
            this.writeString(session, in, out);
        } else {
            LOG.debug("No complete message in this packet");
        }
        return foundEnd;
    }

    private void writeString(IoSession session, IoBuffer in, ProtocolDecoderOutput out) {
        DecoderState state = this.decoderState(session);
        if (state.posStart == 0) {
            LOG.warn("No start byte found, reading from beginning of data");
        }
        in.position(state.posStart);
        try {
            String body = in.getString(state.length(), this.charsetDecoder(session));
            LOG.debug("Decoded HL7 from byte stream of length {} to String of length {}", (Object)state.length(), (Object)body.length());
            if (this.config.isConvertLFtoCR()) {
                body = body.replace('\n', '\r');
            }
            out.write((Object)body);
            state.reset();
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    private CharsetDecoder charsetDecoder(IoSession session) {
        CharsetDecoder decoder = (CharsetDecoder)session.getAttribute((Object)CHARSET_DECODER);
        if (decoder == null) {
            decoder = this.config.getCharset().newDecoder();
            session.setAttribute((Object)CHARSET_DECODER, (Object)decoder);
        }
        return decoder;
    }

    private boolean scan(IoSession session, IoBuffer in) {
        DecoderState state = this.decoderState(session);
        in.position(state.current);
        LOG.debug("Start scanning buffer at position {}", (Object)in.position());
        while (in.hasRemaining()) {
            byte b = in.get();
            if (b == this.config.getStartByte()) {
                if (state.posStart > 0 || state.waitingForEndByte2) {
                    LOG.warn("Ignoring message start at position {} before previous message has ended.", (Object)in.position());
                } else {
                    state.posStart = in.position();
                    state.waitingForEndByte2 = false;
                    LOG.debug("Message starts at position {}", (Object)state.posStart);
                }
            }
            if (b == this.config.getEndByte1()) {
                if (!state.waitingForEndByte2 && state.posStart > 0) {
                    state.waitingForEndByte2 = true;
                } else {
                    LOG.warn("Ignoring unexpected 1st end byte {}. Expected 2nd endpoint {}", (Object)b, (Object)Character.valueOf(this.config.getEndByte2()));
                }
            }
            if (b != this.config.getEndByte2() || !state.waitingForEndByte2) continue;
            state.posEnd = in.position() - 2;
            state.waitingForEndByte2 = false;
            LOG.debug("Message ends at position {}", (Object)state.posEnd);
            break;
        }
        state.current = in.position();
        in.rewind();
        return state.posEnd > 0;
    }

    private DecoderState decoderState(IoSession session) {
        DecoderState decoderState = (DecoderState)session.getAttribute((Object)DECODER_STATE);
        if (decoderState == null) {
            decoderState = new DecoderState();
            session.setAttribute((Object)DECODER_STATE, (Object)decoderState);
        }
        return decoderState;
    }

    public void dispose(IoSession session) throws Exception {
        session.removeAttribute((Object)CHARSET_DECODER);
        session.removeAttribute((Object)DECODER_STATE);
    }

    private static class DecoderState {
        int posStart;
        int posEnd;
        int current;
        boolean waitingForEndByte2;

        private DecoderState() {
        }

        int length() {
            return this.posEnd - this.posStart;
        }

        void reset() {
            this.posStart = 0;
            this.posEnd = 0;
            this.waitingForEndByte2 = false;
        }
    }
}

