/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.llp.CharSetUtil;
import ca.uhn.hl7v2.llp.LLPException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

class MllpEncoder {
    protected Charset charset;
    protected boolean omitBOM;

    MllpEncoder(Charset charset, boolean omitBOM) {
        this.charset = charset;
        this.omitBOM = omitBOM;
    }

    public void putMessage(String message, OutputStream out) throws IOException, LLPException {
        byte[] bytes = this.toByteArray(message);
        byte[] outBytes = new byte[bytes.length + 3];
        outBytes[0] = 11;
        System.arraycopy(bytes, 0, outBytes, 1, bytes.length);
        outBytes[outBytes.length - 2] = 28;
        outBytes[outBytes.length - 1] = 13;
        out.write(outBytes);
        out.flush();
    }

    protected byte[] toByteArray(String message) {
        return MllpEncoder.asByteArray(message, this.charset, this.omitBOM);
    }

    protected static byte[] asByteArray(String message, Charset charset, boolean omitBOM) {
        try {
            byte[] b = message.getBytes(charset.name());
            return omitBOM ? CharSetUtil.withoutBOM(b) : b;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

