/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.Severity;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.builder.BuilderSupport;
import ca.uhn.hl7v2.validation.builder.EncodingRuleBuilder;
import ca.uhn.hl7v2.validation.builder.MessageRuleBuilder;
import ca.uhn.hl7v2.validation.builder.PrimitiveRuleBuilder;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import ca.uhn.hl7v2.validation.impl.RuleSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleTypeBuilder<S extends RuleTypeBuilder<S, T>, T extends Rule<?>>
extends BuilderSupport {
    private List<RuleBinding<? extends Rule<?>>> rules = new ArrayList();
    private Set<Version> versions;
    private String description;
    private String sectionReference;
    private boolean active = true;
    private Severity severity = Severity.ERROR;

    protected RuleTypeBuilder() {
    }

    protected RuleTypeBuilder(List<RuleBinding<? extends Rule<?>>> rules, Set<Version> versions) {
        if (versions.size() == 0) {
            throw new IllegalArgumentException("Must specify a version");
        }
        this.rules = rules;
        this.versions = versions;
    }

    protected RuleTypeBuilder(List<RuleBinding<? extends Rule<?>>> rules, Version ... versions) {
        if (versions.length == 0) {
            throw new IllegalArgumentException("Must specify a version");
        }
        this.rules = rules;
        this.versions = new HashSet<Version>(Arrays.asList(versions));
    }

    protected S instance() {
        return (S)this;
    }

    protected List<RuleBinding<? extends Rule<?>>> getRules() {
        return this.rules;
    }

    protected T prepareRule(T rule) {
        if (rule instanceof RuleSupport) {
            RuleSupport rs = (RuleSupport)rule;
            if (this.description != null) {
                rs.setDescription(this.description);
            }
            if (this.sectionReference != null) {
                rs.setSectionReference(this.sectionReference);
            }
            rs.setSeverity(this.severity);
        }
        return rule;
    }

    public S description(String description) {
        this.description = description;
        return this.instance();
    }

    public S refersToSection(String sectionReference) {
        this.sectionReference = sectionReference;
        return this.instance();
    }

    public S severity(Severity severity) {
        this.severity = severity;
        return this.instance();
    }

    public S active(boolean active) {
        this.active = active;
        return this.instance();
    }

    public S test(T rule) {
        this.addRuleBindings(rule);
        return this.instance();
    }

    public PrimitiveRuleBuilder primitive(String ... type) {
        if (type.length == 0) {
            throw new IllegalArgumentException("Must specify a type");
        }
        return new PrimitiveRuleBuilder(this.rules, this.versions, new HashSet<String>(Arrays.asList(type)));
    }

    public MessageRuleBuilder message(String eventType, String triggerEvent) {
        return new MessageRuleBuilder(this.rules, this.versions, eventType, triggerEvent);
    }

    public MessageExpressionBuilder message() {
        return new MessageExpressionBuilder();
    }

    public EncodingRuleBuilder encoding(String encoding) {
        return new EncodingRuleBuilder(this.rules, this.versions, encoding);
    }

    protected void addRuleBindings(T rule) {
        if (Version.allVersions(this.versions)) {
            this.rules.addAll(this.getRuleBindings(rule, "*"));
        } else {
            for (Version version : this.versions) {
                this.rules.addAll(this.getRuleBindings(rule, version.getVersion()));
            }
        }
    }

    protected Collection<RuleBinding<T>> getRuleBindings(T rule, String version) {
        return Collections.EMPTY_LIST;
    }

    protected Collection<RuleBinding<T>> activate(Collection<RuleBinding<T>> bindings) {
        for (RuleBinding<T> ruleBinding : bindings) {
            ruleBinding.setActive(this.active);
        }
        return bindings;
    }

    Set<Version> getVersions() {
        return this.versions;
    }

    public class MessageExpressionBuilder {
        public MessageRuleBuilder all() {
            return new MessageRuleBuilder(RuleTypeBuilder.this.rules, RuleTypeBuilder.this.versions, "*", "*");
        }

        public MessageRuleBuilder allOfEventType(String eventType) {
            return new MessageRuleBuilder(RuleTypeBuilder.this.rules, RuleTypeBuilder.this.versions, eventType, "*");
        }
    }
}

