/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.impl.AbstractPrimitiveTypeRule;
import java.util.regex.Pattern;

public class TrimTrailingWhitespace
extends AbstractPrimitiveTypeRule {
    private static final Pattern TRAILING_WHITESPACE = Pattern.compile("\\s+$");

    public String correct(String value) {
        return value != null ? TRAILING_WHITESPACE.matcher(value).replaceAll("") : null;
    }

    public ValidationException[] apply(String value) {
        return this.passed();
    }

    public String getDescription() {
        return "Trailing whitespace removed";
    }
}

