/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpException;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.remote.RemoteFile;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileConsumer;
import org.apache.camel.component.file.remote.RemoteFileEndpoint;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;

public class SftpConsumer
extends RemoteFileConsumer<ChannelSftp.LsEntry> {
    private String endpointPath;

    public SftpConsumer(RemoteFileEndpoint<ChannelSftp.LsEntry> endpoint, Processor processor, RemoteFileOperations<ChannelSftp.LsEntry> operations) {
        super(endpoint, processor, operations);
        this.endpointPath = endpoint.getConfiguration().getDirectory();
    }

    protected boolean pollDirectory(String fileName, List<GenericFile<ChannelSftp.LsEntry>> fileList, int depth) {
        String currentDir = null;
        if (this.isStepwise()) {
            currentDir = this.operations.getCurrentDirectory();
        }
        fileName = FileUtil.stripTrailingSeparator((String)fileName);
        boolean answer = this.doPollDirectory(fileName, (String)null, fileList, depth);
        if (currentDir != null) {
            this.operations.changeCurrentDirectory(currentDir);
        }
        return answer;
    }

    protected boolean pollSubDirectory(String absolutePath, String dirName, List<GenericFile<ChannelSftp.LsEntry>> fileList, int depth) {
        boolean answer = this.doSafePollSubDirectory(absolutePath, dirName, fileList, depth);
        if (this.isStepwise()) {
            this.operations.changeToParentDirectory();
        }
        return answer;
    }

    @Override
    protected boolean doPollDirectory(String absolutePath, String dirName, List<GenericFile<ChannelSftp.LsEntry>> fileList, int depth) {
        String dir;
        this.log.trace("doPollDirectory from absolutePath: {}, dirName: {}", (Object)absolutePath, (Object)dirName);
        ++depth;
        dirName = FileUtil.stripTrailingSeparator((String)dirName);
        if (this.isStepwise()) {
            dir = ObjectHelper.isNotEmpty((Object)dirName) ? dirName : absolutePath;
            this.operations.changeCurrentDirectory(dir);
        } else {
            dir = absolutePath;
        }
        this.log.trace("Polling directory: {}", (Object)dir);
        List files = this.isStepwise() ? this.operations.listFiles() : this.operations.listFiles(dir);
        if (files == null || files.isEmpty()) {
            this.log.trace("No files found in directory: {}", (Object)dir);
            return true;
        }
        this.log.trace("Found {} in directory: {}", (Object)files.size(), (Object)dir);
        for (ChannelSftp.LsEntry file : files) {
            RemoteFile<ChannelSftp.LsEntry> remote;
            if (this.log.isTraceEnabled()) {
                this.log.trace("SftpFile[fileName={}, longName={}, dir={}]", new Object[]{file.getFilename(), file.getLongname(), file.getAttrs().isDir()});
            }
            if (!this.canPollMoreFiles(fileList)) {
                return false;
            }
            if (file.getAttrs().isDir()) {
                remote = this.asRemoteFile(absolutePath, file, this.getEndpoint().getCharset());
                if (!this.endpoint.isRecursive() || depth >= this.endpoint.getMaxDepth() || !this.isValidFile(remote, true, files)) continue;
                String subDirectory = file.getFilename();
                String path = absolutePath + "/" + subDirectory;
                boolean canPollMore = this.pollSubDirectory(path, subDirectory, fileList, depth);
                if (canPollMore) continue;
                return false;
            }
            remote = this.asRemoteFile(absolutePath, file, this.getEndpoint().getCharset());
            if (depth < this.endpoint.getMinDepth() || !this.isValidFile(remote, false, files)) continue;
            fileList.add(remote);
        }
        return true;
    }

    protected boolean isMatched(GenericFile<ChannelSftp.LsEntry> file, String doneFileName, List<ChannelSftp.LsEntry> files) {
        String onlyName = FileUtil.stripPath((String)doneFileName);
        for (ChannelSftp.LsEntry f : files) {
            if (!f.getFilename().equals(onlyName)) continue;
            return true;
        }
        this.log.trace("Done file: {} does not exist", (Object)doneFileName);
        return false;
    }

    protected boolean ignoreCannotRetrieveFile(String name, Exchange exchange, Exception cause) {
        SftpException sftp;
        if (this.getEndpoint().getConfiguration().isIgnoreFileNotFoundOrPermissionError() && (sftp = (SftpException)ObjectHelper.getException(SftpException.class, (Throwable)cause)) != null) {
            return sftp.id == 2 || sftp.id == 3;
        }
        return super.ignoreCannotRetrieveFile(name, exchange, cause);
    }

    private RemoteFile<ChannelSftp.LsEntry> asRemoteFile(String absolutePath, ChannelSftp.LsEntry file, String charset) {
        RemoteFile<ChannelSftp.LsEntry> answer = new RemoteFile<ChannelSftp.LsEntry>();
        answer.setCharset(charset);
        answer.setEndpointPath(this.endpointPath);
        answer.setFile(file);
        answer.setFileNameOnly(file.getFilename());
        answer.setFileLength(file.getAttrs().getSize());
        answer.setLastModified((long)file.getAttrs().getMTime() * 1000L);
        answer.setHostname(((RemoteFileConfiguration)this.endpoint.getConfiguration()).getHost());
        answer.setDirectory(file.getAttrs().isDir());
        boolean absolute = FileUtil.hasLeadingSeparator((String)absolutePath);
        answer.setAbsolute(absolute);
        String dir = FileUtil.stripTrailingSeparator((String)absolutePath);
        String absoluteFileName = FileUtil.stripLeadingSeparator((String)(dir + "/" + file.getFilename()));
        if (absolute) {
            absoluteFileName = "/" + absoluteFileName;
        }
        answer.setAbsoluteFilePath(absoluteFileName);
        String relativePath = ObjectHelper.after((String)absoluteFileName, (String)this.endpointPath);
        relativePath = FileUtil.stripLeadingSeparator((String)relativePath);
        answer.setRelativeFilePath(relativePath);
        answer.setFileName(answer.getRelativeFilePath());
        return answer;
    }

    private boolean isStepwise() {
        RemoteFileConfiguration config = (RemoteFileConfiguration)this.endpoint.getConfiguration();
        return config.isStepwise();
    }
}

