/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.sql.DefaultSqlPrepareStatementStrategy;
import org.apache.camel.component.sql.DefaultSqlProcessingStrategy;
import org.apache.camel.component.sql.SqlConsumer;
import org.apache.camel.component.sql.SqlOutputType;
import org.apache.camel.component.sql.SqlPrepareStatementStrategy;
import org.apache.camel.component.sql.SqlProcessingStrategy;
import org.apache.camel.component.sql.SqlProducer;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;

@UriEndpoint(scheme="sql", syntax="sql:query", consumerClass=SqlConsumer.class, label="database,sql")
public class SqlEndpoint
extends DefaultPollingEndpoint {
    private JdbcTemplate jdbcTemplate;
    @UriPath
    @Metadata(required="true")
    private String query;
    @UriParam
    @Deprecated
    private String dataSourceRef;
    @UriParam
    private DataSource dataSource;
    @UriParam
    private boolean batch;
    @UriParam
    private int maxMessagesPerPoll;
    @UriParam
    private SqlProcessingStrategy processingStrategy;
    @UriParam
    private SqlPrepareStatementStrategy prepareStatementStrategy;
    @UriParam
    private String onConsume;
    @UriParam
    private String onConsumeFailed;
    @UriParam
    private String onConsumeBatchComplete;
    @UriParam(defaultValue="true")
    private boolean allowNamedParameters = true;
    @UriParam
    private boolean alwaysPopulateStatement;
    @UriParam(defaultValue=",")
    private char separator = (char)44;
    @UriParam(defaultValue="SelectList")
    private SqlOutputType outputType = SqlOutputType.SelectList;
    @UriParam
    private String outputClass;
    @UriParam
    private int parametersCount;
    @UriParam
    private boolean noop;
    @UriParam
    private String outputHeader;

    public SqlEndpoint() {
    }

    public SqlEndpoint(String uri, Component component, JdbcTemplate jdbcTemplate, String query) {
        super(uri, component);
        this.jdbcTemplate = jdbcTemplate;
        this.query = query;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SqlPrepareStatementStrategy prepareStrategy = this.prepareStatementStrategy != null ? this.prepareStatementStrategy : new DefaultSqlPrepareStatementStrategy(this.separator);
        SqlProcessingStrategy proStrategy = this.processingStrategy != null ? this.processingStrategy : new DefaultSqlProcessingStrategy(prepareStrategy);
        SqlConsumer consumer = new SqlConsumer(this, processor, this.jdbcTemplate, this.query, prepareStrategy, proStrategy);
        consumer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        consumer.setOnConsume(this.getOnConsume());
        consumer.setOnConsumeFailed(this.getOnConsumeFailed());
        consumer.setOnConsumeBatchComplete(this.getOnConsumeBatchComplete());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        SqlPrepareStatementStrategy prepareStrategy = this.prepareStatementStrategy != null ? this.prepareStatementStrategy : new DefaultSqlPrepareStatementStrategy(this.separator);
        SqlProducer result = new SqlProducer(this, this.query, this.jdbcTemplate, prepareStrategy, this.batch, this.alwaysPopulateStatement);
        result.setParametersCount(this.parametersCount);
        return result;
    }

    public boolean isSingleton() {
        return true;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public SqlProcessingStrategy getProcessingStrategy() {
        return this.processingStrategy;
    }

    public void setProcessingStrategy(SqlProcessingStrategy processingStrategy) {
        this.processingStrategy = processingStrategy;
    }

    public SqlPrepareStatementStrategy getPrepareStatementStrategy() {
        return this.prepareStatementStrategy;
    }

    public void setPrepareStatementStrategy(SqlPrepareStatementStrategy prepareStatementStrategy) {
        this.prepareStatementStrategy = prepareStatementStrategy;
    }

    public String getOnConsume() {
        return this.onConsume;
    }

    public void setOnConsume(String onConsume) {
        this.onConsume = onConsume;
    }

    public String getOnConsumeFailed() {
        return this.onConsumeFailed;
    }

    public void setOnConsumeFailed(String onConsumeFailed) {
        this.onConsumeFailed = onConsumeFailed;
    }

    public String getOnConsumeBatchComplete() {
        return this.onConsumeBatchComplete;
    }

    public void setOnConsumeBatchComplete(String onConsumeBatchComplete) {
        this.onConsumeBatchComplete = onConsumeBatchComplete;
    }

    public boolean isAllowNamedParameters() {
        return this.allowNamedParameters;
    }

    public void setAllowNamedParameters(boolean allowNamedParameters) {
        this.allowNamedParameters = allowNamedParameters;
    }

    public boolean isAlwaysPopulateStatement() {
        return this.alwaysPopulateStatement;
    }

    public void setAlwaysPopulateStatement(boolean alwaysPopulateStatement) {
        this.alwaysPopulateStatement = alwaysPopulateStatement;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public SqlOutputType getOutputType() {
        return this.outputType;
    }

    public void setOutputType(SqlOutputType outputType) {
        this.outputType = outputType;
    }

    public String getOutputClass() {
        return this.outputClass;
    }

    public void setOutputClass(String outputClass) {
        this.outputClass = outputClass;
    }

    public int getParametersCount() {
        return this.parametersCount;
    }

    public void setParametersCount(int parametersCount) {
        this.parametersCount = parametersCount;
    }

    public boolean isNoop() {
        return this.noop;
    }

    public void setNoop(boolean noop) {
        this.noop = noop;
    }

    public String getOutputHeader() {
        return this.outputHeader;
    }

    public void setOutputHeader(String outputHeader) {
        this.outputHeader = outputHeader;
    }

    public String getDataSourceRef() {
        return this.dataSourceRef;
    }

    public void setDataSourceRef(String dataSourceRef) {
        this.dataSourceRef = dataSourceRef;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    protected String createEndpointUri() {
        return "sql:" + UnsafeUriCharactersEncoder.encode((String)this.query);
    }

    protected List<?> queryForList(ResultSet rs, boolean allowMapToClass) throws SQLException {
        if (allowMapToClass && this.outputClass != null) {
            Class outputClzz = this.getCamelContext().getClassResolver().resolveClass(this.outputClass);
            BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(outputClzz);
            RowMapperResultSetExtractor mapper = new RowMapperResultSetExtractor((RowMapper)rowMapper);
            List data = mapper.extractData(rs);
            return data;
        }
        ColumnMapRowMapper rowMapper = new ColumnMapRowMapper();
        RowMapperResultSetExtractor mapper = new RowMapperResultSetExtractor((RowMapper)rowMapper);
        List data = mapper.extractData(rs);
        return data;
    }

    protected Object queryForObject(ResultSet rs) throws SQLException {
        Map result = null;
        if (this.outputClass == null) {
            ColumnMapRowMapper rowMapper = new ColumnMapRowMapper();
            RowMapperResultSetExtractor mapper = new RowMapperResultSetExtractor((RowMapper)rowMapper);
            List data = mapper.extractData(rs);
            if (data.size() > 1) {
                throw new SQLDataException("Query result not unique for outputType=SelectOne. Got " + data.size() + " count instead.");
            }
            if (data.size() == 1) {
                Map row = (Map)data.get(0);
                result = row.size() == 1 ? row.values().iterator().next() : row;
            }
        } else {
            Class outputClzz = this.getCamelContext().getClassResolver().resolveClass(this.outputClass);
            BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(outputClzz);
            RowMapperResultSetExtractor mapper = new RowMapperResultSetExtractor((RowMapper)rowMapper);
            List data = mapper.extractData(rs);
            if (data.size() > 1) {
                throw new SQLDataException("Query result not unique for outputType=SelectOne. Got " + data.size() + " count instead.");
            }
            if (data.size() == 1) {
                result = data.get(0);
            }
        }
        return result;
    }
}

